/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.decryption;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.xforceplus.finance.dvas.common.service.decryption.CryptType;
import com.xforceplus.finance.dvas.common.service.kms.KmsUtils;
import com.xforceplus.finance.dvas.common.utils.DBEncryptUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@MappedTypes(value={CryptType.class})
@Service
public class CryptTypeHandler
extends BaseTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(CryptTypeHandler.class);
    @Autowired
    private KmsUtils kmsUtils;
    private String des_key;
    @Value(value="${dbencrypt.key:}")
    private String dbKey;
    @Value(value="${aliyun.kms.dbKey:}")
    private String kmsDBKey;

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Object o, JdbcType jdbcType) throws SQLException {
        this.des_key = this.getDesKey();
        String encryptStr = DBEncryptUtils.encryptDESede(o.toString(), this.des_key);
        preparedStatement.setString(i, encryptStr);
    }

    public Object getNullableResult(ResultSet resultSet, String s) throws SQLException {
        String str = resultSet.getString(s);
        return this.decrypt(str);
    }

    public Object getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String str = resultSet.getString(i);
        return this.decrypt(str);
    }

    public Object getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        String str = callableStatement.getString(i);
        return this.decrypt(str);
    }

    private String decrypt(String origin) {
        this.des_key = this.getDesKey();
        String decryptStr = DBEncryptUtils.decryptDESede(origin, this.des_key);
        return decryptStr;
    }

    private String getDesKey() {
        this.dbKey = this.kmsDBKey;
        if (StringUtils.hasLength((String)this.dbKey)) {
            TimeInterval timer = DateUtil.timer();
            this.des_key = this.kmsUtils.getSecretValue(this.dbKey).getSecretData();
            long time = timer.interval();
            log.info("[\u8c03\u7528kms\u83b7\u53d6\u51ed\u636e\u8017\u65f6] time\uff1a{}", (Object)time);
        } else {
            this.des_key = this.dbKey;
        }
        return this.des_key;
    }
}

