/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.finance.dvas.common.api.qcc.CompanyContext;
import com.xforceplus.finance.dvas.common.api.qcc.QccBusinessApi;
import com.xforceplus.finance.dvas.common.config.riskstorm.RiskStormConfig;
import com.xforceplus.finance.dvas.common.constant.riskstorm.CompanySourceTypeEnum;
import com.xforceplus.finance.dvas.common.constant.riskstorm.RiskStormApiEnum;
import com.xforceplus.finance.dvas.common.constant.riskstorm.RiskStormConstant;
import com.xforceplus.finance.dvas.common.dto.CompanyInfoDto;
import com.xforceplus.finance.dvas.common.dto.CompanySearchDto;
import com.xforceplus.finance.dvas.common.dto.CompanySearchResData;
import com.xforceplus.finance.dvas.common.enums.Message;
import com.xforceplus.finance.dvas.common.exception.BusinessCheckException;
import com.xforceplus.finance.dvas.common.service.ICompanyService;
import com.xforceplus.finance.dvas.common.utils.CompanyCode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@CompanyCode(value="FB", name="\u4f01\u67e5\u67e5")
public class FbCompanyApiImpl
implements ICompanyService {
    private static final Logger log = LoggerFactory.getLogger(FbCompanyApiImpl.class);
    @Autowired
    private RiskStormConfig config;
    @Autowired
    private QccBusinessApi qccBusinessApi;

    public Page<CompanySearchDto> searchCompanyListByName(String keyWord, String sourceType, String businessCode, long size, long current) {
        log.info("==x==>\u6839\u636e\u516c\u53f8\u540d\u641c\u7d22\u516c\u53f8>>>>>>>>start:\u6570\u636e\u6765\u6e90[{}];\u4e1a\u52a1\u7f16\u7801[{}],\u641c\u7d22\u5173\u952e\u5b57[{}],\u9875\u7801[{},{}]", new Object[]{sourceType, businessCode, keyWord, current, size});
        if (size * current > 1000L) {
            throw new BusinessCheckException(Message.PAGE_SIZE_CHECK_ERR);
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("keyword", keyWord);
        paraMap.put("size", size);
        paraMap.put("from", (current - 1L) * size);
        CompanySearchResData company = this.get(RiskStormApiEnum.COMPANY_SEARCH, paraMap, RiskStormConstant.COMPANY_SEARCH_MAP, CompanySearchResData.class);
        if (CollUtil.isEmpty((Collection)company.getHits())) {
            throw new BusinessCheckException(Message.SEARCH_NO_RESULT);
        }
        company.getHits().stream().filter(s -> CollUtil.isNotEmpty((Collection)s.getOriginalName())).forEach(m -> m.setOriginalName(m.getOriginalName().stream().map(t -> JSONUtil.parseObj((String)StrUtil.format((CharSequence)"{\"changeDate\":\"\",\"name\":\"{}\"}", (Object[])new Object[]{t}))).collect(Collectors.toList())));
        Page result = new Page(current, size, company.getTotal());
        result.setRecords(company.getHits());
        return result;
    }

    public CompanyInfoDto getCompanyInfoByCreditCode(String creditCode, String sourceType, String businessCode) {
        log.info("==x==>\u6839\u636e\u7a0e\u53f7\u67e5\u8be2\u5de5\u5546\u4fe1\u606f>>>>>>>>start:\u6570\u636e\u6765\u6e90[{}];\u4e1a\u52a1\u7f16\u7801[{}],\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801[{}]", new Object[]{sourceType, businessCode, creditCode});
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("creditCode", creditCode);
        CompanyInfoDto companyDto = this.get(RiskStormApiEnum.COMPANY_DETAIL, paraMap, RiskStormConstant.COMPANY_DETAIL_MAP, CompanyInfoDto.class);
        if (CollUtil.isNotEmpty((Collection)companyDto.getOriginalName())) {
            companyDto.setOriginalName(companyDto.getOriginalName().stream().map(t -> JSONUtil.parseObj((String)StrUtil.format((CharSequence)"{\"changeDate\":\"\",\"name\":\"{}\"}", (Object[])new Object[]{t}))).collect(Collectors.toList()));
        }
        return companyDto;
    }

    private <T> T get(RiskStormApiEnum apiEnum, Map<String, Object> paramMap, Map<String, String> transMap, Class<T> resClass) {
        paramMap.put("host", this.config.getHttpUrl());
        paramMap.put("apikey", this.config.getApikey());
        String url = StrUtil.format((CharSequence)apiEnum.getPath(), paramMap, (boolean)false);
        log.info(StrUtil.format((CharSequence)"==xc==>[\u98ce\u62a5]-{} \u63a5\u53e3Url:{}", (Object[])new Object[]{apiEnum.getDesc(), url}));
        TimeInterval timer = DateUtil.timer();
        HttpResponse response = HttpRequest.get((String)url).timeout(20000).execute();
        log.info(StrUtil.format((CharSequence)"==xc==>[\u98ce\u62a5]-{} \u63a5\u53e3\u8bf7\u6c42\u7ed3\u679c\u72b6\u6001\u7801:{}", (Object[])new Object[]{apiEnum.getDesc(), response.getStatus()}));
        String resStr = response.body();
        this.qccBusinessApi.recordLog(CompanySourceTypeEnum.FB, apiEnum.getCode(), apiEnum.getDesc(), paramMap.toString(), resStr, new CompanyContext(), String.valueOf(response.getStatus()), timer.interval());
        if (response.getStatus() != 200) {
            log.warn("[\u8c03\u7528\u670d\u52a1\u54cd\u5e94\u5931\u8d25-\u8c03\u7528[\u98ce\u62a5]\u63a5\u53e3\u54cd\u5e94\u5931\u8d25] response:{}", (Object)resStr);
            throw new BusinessCheckException(Message.SEARCH_NO_RESULT);
        }
        for (Map.Entry<String, String> entry : transMap.entrySet()) {
            resStr = resStr.replaceAll(entry.getKey(), entry.getValue());
        }
        return (T)JSONUtil.toBean((String)resStr, resClass);
    }
}

