/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.finance.dvas.common.dto.HolidayDto;
import com.xforceplus.finance.dvas.common.entity.NonWorkingDay;
import com.xforceplus.finance.dvas.common.enums.Message;
import com.xforceplus.finance.dvas.common.exception.BusinessCheckException;
import com.xforceplus.finance.dvas.common.repository.NonWorkingDayMapper;
import com.xforceplus.finance.dvas.common.service.INonWorkingDayService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"NonWorkingDay"})
public class NonWorkingDayServiceImpl
extends ServiceImpl<NonWorkingDayMapper, NonWorkingDay>
implements INonWorkingDayService {
    private static final Logger log = LoggerFactory.getLogger(NonWorkingDayServiceImpl.class);
    private static final String EARLIEST_DATE = "20190101";
    @Value(value="${holiday.check.flag:false}")
    private String holidayCheckFlag;

    @Cacheable(keyGenerator="simpleKeyGenerator")
    public List<HolidayDto> markHoliday(String beginDate, String endDate, String businessCode) {
        log.info("==x==>\u6807\u8bb0\u8282\u5047\u65e5>>>>>>>>start:businessCode:[{}],beginDate:[{}],endDate:[{}]", new Object[]{businessCode, beginDate, endDate});
        DateTime begin = DateUtil.parse((CharSequence)beginDate, (String)"yyyyMMdd", null);
        DateTime end = DateUtil.parse((CharSequence)endDate, (String)"yyyyMMdd", null);
        if (begin.isAfter((Date)end) || begin.isBefore((Date)DateUtil.parse((CharSequence)EARLIEST_DATE))) {
            throw new BusinessCheckException(Message.DATE_RANGE_CHECK_ERR);
        }
        if (Boolean.TRUE.toString().equals(this.holidayCheckFlag) && end.isAfter((Date)DateUtil.endOfYear((Date)DateUtil.date()))) {
            throw new BusinessCheckException(Message.DATE_RANGE_CHECK_ERR);
        }
        int betweenDay = Math.toIntExact(DateUtil.betweenDay((Date)begin, (Date)end, (boolean)true));
        HashMap dateMap = MapUtil.newHashMap((int)(betweenDay + 1), (boolean)true);
        Map<String, Integer> specialDayMap = this.list().stream().collect(Collectors.toMap(NonWorkingDay::getDay, NonWorkingDay::getStatus));
        for (int i = 0; i <= betweenDay; ++i) {
            String date;
            dateMap.put(date, DateUtil.parse((CharSequence)(date = DateUtil.format((Date)DateUtil.offsetDay((Date)begin, (int)i), (String)"yyyyMMdd"))).isWeekend() != specialDayMap.containsKey(date));
        }
        return dateMap.entrySet().stream().map(item -> new HolidayDto((String)item.getKey(), (Boolean)item.getValue())).collect(Collectors.toList());
    }

    public String getWorkDay(String strDate, Integer days) {
        log.info("\u3010\u6267\u884c\u83b7\u53d6\u5de5\u4f5c\u65e5\u63a5\u53e3\u3011strDate:{}, days:{}", (Object)strDate, (Object)days);
        Date currentDate = com.xforceplus.finance.dvas.common.utils.DateUtil.toDate(strDate, "yyyy-MM-dd");
        List nonWorkingDays = this.list();
        Map<String, Integer> map = nonWorkingDays.stream().collect(Collectors.toMap(NonWorkingDay::getDay, NonWorkingDay::getStatus));
        if (days == 0) {
            Boolean boo = com.xforceplus.finance.dvas.common.utils.DateUtil.isWorkDay(currentDate);
            String str = NonWorkingDayServiceImpl.changeStrFormat(strDate);
            if (boo.booleanValue() && !map.containsKey(str)) {
                return strDate;
            }
            days = 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        int step = days < 0 ? -1 : 1;
        int i = 0;
        int daysAbs = Math.abs(days);
        while (i < daysAbs) {
            calendar.add(5, step);
            ++i;
            Integer status = map.get(DateUtil.format((Date)calendar.getTime(), (String)"yyyyMMdd"));
            if (calendar.get(7) == 7 || calendar.get(7) == 1) {
                if (!ObjectUtil.isNull((Object)status) && map.get(DateUtil.format((Date)calendar.getTime(), (String)"yyyyMMdd")).equals(2)) continue;
                --i;
                continue;
            }
            if (!ObjectUtil.isNotNull((Object)status) || !map.get(DateUtil.format((Date)calendar.getTime(), (String)"yyyyMMdd")).equals(1)) continue;
            --i;
        }
        String result = com.xforceplus.finance.dvas.common.utils.DateUtil.getDateStr(calendar.getTime(), "yyyy-MM-dd");
        return result;
    }

    private static String changeStrFormat(String strDate) {
        LocalDate localDate = LocalDate.parse(strDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }
}

