/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.finance.dvas.common.dto.CompanyInfoDto;
import com.xforceplus.finance.dvas.common.entity.PurchaseCompanyInfo;
import com.xforceplus.finance.dvas.common.repository.PurchaseCompanyInfoMapper;
import com.xforceplus.finance.dvas.common.service.IPurchaseCompanyInfoService;
import com.xforceplus.finance.dvas.common.service.impl.QccCompanyApiImpl;
import com.xforceplus.finance.dvas.common.utils.ThreadPoolUtils;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseCompanyInfoServiceImpl
extends ServiceImpl<PurchaseCompanyInfoMapper, PurchaseCompanyInfo>
implements IPurchaseCompanyInfoService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseCompanyInfoServiceImpl.class);
    @Resource
    private PurchaseCompanyInfoMapper purchaseCompanyInfoMapper;
    @Autowired
    private QccCompanyApiImpl qccCompanyApi;

    public void updateCompany() {
        log.info("[\u6267\u884c\u66f4\u65b0\u516c\u53f8\u4fe1\u606f\u63a5\u53e3]");
        List taxNums = this.purchaseCompanyInfoMapper.queryMatchTaxNum();
        if (CollectionUtils.isEmpty((Collection)taxNums)) {
            log.info("[\u65e0\u5339\u914d\u7a0e\u53f7,\u6267\u884c\u7ed3\u675f]");
            return;
        }
        this.handCompanyInfo(taxNums);
    }

    private void handCompanyInfo(List<String> taxNums) {
        ThreadPoolExecutor poolExecutor = ThreadPoolUtils.getInstance();
        taxNums.stream().forEach(taxNum -> poolExecutor.submit(() -> this.doHandCompanyInfo((String)taxNum)));
    }

    private boolean doHandCompanyInfo(String taxNum) {
        int size = 0;
        try {
            String sourceType = "QCC";
            String businessCode = "QCC";
            log.info("[\u5f53\u524d\u7a0e\u53f7] taxNum:{}", (Object)taxNum);
            CompanyInfoDto companyInfoDto = this.qccCompanyApi.getCompanyInfoByCreditCode(taxNum, sourceType, businessCode);
            LocalDateTime now = LocalDateTime.now();
            PurchaseCompanyInfo purchaseCompanyInfo = new PurchaseCompanyInfo();
            purchaseCompanyInfo.setThirdCompanyName(companyInfoDto.getName());
            purchaseCompanyInfo.setCallTime(now);
            purchaseCompanyInfo.setThirdCompanyInfo(JSON.toJSONString((Object)companyInfoDto));
            purchaseCompanyInfo.setStatus(companyInfoDto.getStatus());
            purchaseCompanyInfo.setUpdateTime(now);
            LambdaQueryWrapper lqw = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseCompanyInfo::getTaxNum, (Object)taxNum);
            size = this.purchaseCompanyInfoMapper.update((Object)purchaseCompanyInfo, (Wrapper)lqw);
        }
        catch (Exception e) {
            log.info("[\u5904\u7406\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38] e:{}", (Throwable)e);
        }
        return size > 0;
    }
}

