/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.finance.dvas.common.accModel.qcc.basicDetailInfo.BasicDetailInfoResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.basicDetailInfo.BasicDetailInfoResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.searchPhone.SearchPhoneResponse;
import com.xforceplus.finance.dvas.common.api.qcc.CompanyContext;
import com.xforceplus.finance.dvas.common.api.qcc.QccBusinessApi;
import com.xforceplus.finance.dvas.common.constant.qcc.QccApiEnum;
import com.xforceplus.finance.dvas.common.convert.IQccDTOConvert;
import com.xforceplus.finance.dvas.common.dto.CompanyInfoDto;
import com.xforceplus.finance.dvas.common.dto.CompanySearchDto;
import com.xforceplus.finance.dvas.common.enums.Message;
import com.xforceplus.finance.dvas.common.exception.BusinessCheckException;
import com.xforceplus.finance.dvas.common.service.ICompanyService;
import com.xforceplus.finance.dvas.common.utils.CompanyCode;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@CompanyCode(value="QCC", name="\u4f01\u67e5\u67e5")
public class QccCompanyApiImpl
implements ICompanyService {
    private static final Logger log = LoggerFactory.getLogger(QccCompanyApiImpl.class);
    @Autowired
    private QccBusinessApi qccBusinessApi;
    @Autowired
    private IQccDTOConvert convert;

    public Page<CompanySearchDto> searchCompanyListByName(String keyWord, String sourceType, String businessCode, long size, long current) {
        log.info("==x==>\u6839\u636e\u516c\u53f8\u540d\u641c\u7d22\u516c\u53f8>>>>>>>>start:\u6570\u636e\u6765\u6e90[{}];\u4e1a\u52a1\u7f16\u7801[{}],\u641c\u7d22\u5173\u952e\u5b57[{}],\u9875\u7801[{},{}]", new Object[]{sourceType, businessCode, keyWord, current, size});
        if (size * current > 1000L) {
            throw new BusinessCheckException(Message.PAGE_SIZE_CHECK_ERR);
        }
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("searchKey", keyWord);
        paraMap.put("pageSize", String.valueOf(size));
        paraMap.put("pageIndex", String.valueOf(current));
        SearchPhoneResponse response = (SearchPhoneResponse)this.qccBusinessApi.get(QccApiEnum.FuzzySearch, paraMap, SearchPhoneResponse.class, new CompanyContext());
        Page result = new Page(current, size, (long)response.getPaging().getTotalRecords().intValue());
        result.setRecords(this.convert.toThirdCompanySearchDtos((List)response.getResult()));
        return result;
    }

    public CompanyInfoDto getCompanyInfoByCreditCode(String creditCode, String sourceType, String businessCode) {
        log.info("==x==>\u6839\u636e\u7a0e\u53f7\u67e5\u8be2\u5de5\u5546\u4fe1\u606f>>>>>>>>start:\u6570\u636e\u6765\u6e90[{}];\u4e1a\u52a1\u7f16\u7801[{}],\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801[{}]", new Object[]{sourceType, businessCode, creditCode});
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("keyword", creditCode);
        BasicDetailInfoResponse response = (BasicDetailInfoResponse)this.qccBusinessApi.get(QccApiEnum.BasicDetails, paraMap, BasicDetailInfoResponse.class, new CompanyContext());
        return this.convert.toThirdCompanyInfoDto((BasicDetailInfoResponseData)response.getResult());
    }
}

