/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.impl.ccb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.finance.dvas.common.dto.ccb.CCBRequestHead;
import com.xforceplus.finance.dvas.common.dto.ccb.CCBResponseBase;
import com.xforceplus.finance.dvas.common.entity.CcbRequestLog;
import com.xforceplus.finance.dvas.common.enums.IsSuccessEnum;
import com.xforceplus.finance.dvas.common.repository.CcbRequestLogMapper;
import java.lang.reflect.Field;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class CCBInvokeHandler {
    private static final Logger log = LoggerFactory.getLogger(CCBInvokeHandler.class);
    @Resource
    private CcbRequestLogMapper ccbRequestLogMapper;

    @Pointcut(value="within(com.xforceplus.finance.dvas.common.service.impl.ccb.*)")
    public void logCut() {
    }

    @AfterThrowing(value="logCut()")
    public void afterThrowing(JoinPoint joinPoint) {
        log.info("ccb invoke exception");
    }

    @AfterReturning(value="logCut()", returning="returnValue")
    public void after(JoinPoint joinPoint, Object returnValue) throws NoSuchFieldException {
        Object[] args = joinPoint.getArgs();
        Class<?> requestClass = args[0].getClass();
        Field ccbRequestHeadField = requestClass.getDeclaredField("ccbRequestHead");
        Field ccbResponseBaseField = returnValue.getClass().getDeclaredField("ccbResponseBase");
        try {
            ccbRequestHeadField.setAccessible(true);
            ccbResponseBaseField.setAccessible(true);
            CCBRequestHead ccbRequestHeadObject = (CCBRequestHead)ccbRequestHeadField.get(args[0]);
            CCBResponseBase ccbResponseBaseObject = (CCBResponseBase)ccbResponseBaseField.get(returnValue);
            String request = JSON.toJSONString((Object)args[0]);
            JSONObject jsonObject = JSONObject.parseObject((String)request);
            if (jsonObject.containsKey((Object)"ccbRequestHead")) {
                JSONObject ccbRequestHead = jsonObject.getJSONObject("ccbRequestHead");
                ccbRequestHead.fluentRemove((Object)"password");
            }
            this.insertLog(ccbRequestHeadObject, ccbResponseBaseObject, jsonObject.toJSONString(), returnValue);
        }
        catch (IllegalAccessException e) {
            log.info("get value error : {}", (Throwable)e);
        }
    }

    private void insertLog(CCBRequestHead ccbRequestHead, CCBResponseBase ccbResponseBase, String request, Object response) {
        try {
            CcbRequestLog ccbRequestLog = new CcbRequestLog();
            ccbRequestLog.setRequestSn(ccbRequestHead.getRequestSN());
            ccbRequestLog.setCustId(ccbRequestHead.getCustId());
            ccbRequestLog.setTxCode(ccbRequestHead.getTxCode());
            ccbRequestLog.setLanguage(ccbRequestHead.getLanguage());
            ccbRequestLog.setRequestData(request);
            ccbRequestLog.setSourceCode("CCB");
            String returnCode = ccbResponseBase.getReturnCode();
            ccbRequestLog.setIsSuccess("000000".equals(returnCode) ? IsSuccessEnum.YES.getFlag() : IsSuccessEnum.NO.getFlag());
            ccbRequestLog.setCreateBy("sys");
            this.ccbRequestLogMapper.insert((Object)ccbRequestLog);
            log.info("[\u63d2\u5165\u5efa\u8bbe\u94f6\u884c\u4ea4\u4e92\u65e5\u5fd7\u5b8c\u6210]");
        }
        catch (Exception e) {
            log.warn("[\u63d2\u5165\u5efa\u8bbe\u94f6\u884c\u4ea4\u4e92\u65e5\u5fd7\u5931\u8d25] e:{}", (Throwable)e);
        }
    }
}

