/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.impl.ccb;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.Sftp;
import com.google.api.client.util.Lists;
import com.google.api.client.util.Maps;
import com.xforceplus.finance.dvas.common.dto.ccb.AccountBalanceInquiryRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.AccountBalanceInquiryResponse;
import com.xforceplus.finance.dvas.common.dto.ccb.CCBRequestHead;
import com.xforceplus.finance.dvas.common.dto.ccb.CCBResponseBase;
import com.xforceplus.finance.dvas.common.dto.ccb.ElectronicReceiptDTO;
import com.xforceplus.finance.dvas.common.dto.ccb.ElectronicReceiptFileDowlandRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.ElectronicReceiptFileDowloadResponse;
import com.xforceplus.finance.dvas.common.dto.ccb.ElectronicReceiptProcessRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.ElectronicReceiptProcessResponse;
import com.xforceplus.finance.dvas.common.dto.ccb.ElectronicReceiptRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.ElectronicReceiptResponse;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailDTO;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailFileDTO;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailInquiryFileDowloadRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailInquiryFileDowloadResponse;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailInquiryFileProcessRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailInquiryFileProcessResponse;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailInquiryFileRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailInquiryFileResponse;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailResponse;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailsInquiryFileDownloadRequest;
import com.xforceplus.finance.dvas.common.dto.ccb.TransactionDetailsInquiryFileDownloadResponse;
import com.xforceplus.finance.dvas.common.service.ICCBService;
import io.swagger.annotations.ApiParam;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Service
public class CCBServiceImpl
implements ICCBService {
    private static final Logger log = LoggerFactory.getLogger(CCBServiceImpl.class);
    @Value(value="${ccb.custId:SHP342290888#001}")
    private String custId;
    @Value(value="${ccb.userId:WLPT01}")
    private String userId;
    @Value(value="${ccb.password:yl20210409}")
    private String password;
    @Value(value="${ccb.language:CN}")
    private String language;
    @Value(value="${ccb.sshHost:10.109.2.21}")
    private String sshHost;
    @Value(value="${ccb.sshPort:22}")
    private Integer sshPort;
    @Value(value="${ccb.sshUser:dvas}")
    private String sshUser;
    @Value(value="${ccb.sshPass:dvas1234}")
    private String sshPass;
    @Value(value="${ccb.url:http://10.109.2.21:18848}")
    private String url;

    public AccountBalanceInquiryResponse balanceInquiry(AccountBalanceInquiryRequest accountBalanceInquiryRequest) {
        accountBalanceInquiryRequest.setCcbRequestHead(this.getCcbRequestHead());
        accountBalanceInquiryRequest.getCcbRequestHead().setTxCode("6W0100");
        Map<String, String> requestHeadMap = CCBServiceImpl.getRequestBodyMap(accountBalanceInquiryRequest.getCcbRequestHead());
        Map<String, String> requestBodyMap = CCBServiceImpl.getRequestBodyMap(accountBalanceInquiryRequest);
        String requestXml = CCBServiceImpl.buildRequestXml(requestHeadMap, requestBodyMap);
        String responseXml = this.sendHttp(requestXml);
        AccountBalanceInquiryResponse accountBalanceInquiryResponse = new AccountBalanceInquiryResponse();
        CCBServiceImpl.responseToObject(responseXml, accountBalanceInquiryResponse);
        return accountBalanceInquiryResponse;
    }

    public TransactionDetailResponse transactionDetailsInquiry(TransactionDetailRequest transactionDetailRequest) {
        transactionDetailRequest.setCcbRequestHead(this.getCcbRequestHead());
        transactionDetailRequest.getCcbRequestHead().setTxCode("6WY101");
        Map<String, String> requestHeadMap = CCBServiceImpl.getRequestBodyMap(transactionDetailRequest.getCcbRequestHead());
        Map<String, String> requestBodyMap = CCBServiceImpl.getRequestBodyMap(transactionDetailRequest);
        String requestXml = CCBServiceImpl.buildRequestXml(requestHeadMap, requestBodyMap);
        String responseXml = this.sendHttp(requestXml);
        TransactionDetailResponse transactionDetailResponse = new TransactionDetailResponse();
        CCBServiceImpl.responseToObject(responseXml, transactionDetailResponse);
        if (!transactionDetailResponse.getCcbResponseBase().getReturnCode().equalsIgnoreCase("000000")) {
            return transactionDetailResponse;
        }
        ArrayList transactionDetailDTOList = Lists.newArrayList();
        transactionDetailResponse.setTransactionDetailDTOList((List)transactionDetailDTOList);
        Map responseBodyMap = XmlUtil.xmlToMap((String)responseXml);
        responseBodyMap = (Map)responseBodyMap.get("TX_INFO");
        if (!(responseBodyMap.get("DETAILLIST") instanceof HashMap)) {
            return transactionDetailResponse;
        }
        if ((responseBodyMap = (Map)responseBodyMap.get("DETAILLIST")).get("DETAILINFO") instanceof Map) {
            TransactionDetailDTO transactionDetailDTO = new TransactionDetailDTO();
            CCBServiceImpl.fillObjectValue(transactionDetailDTO, (Map)responseBodyMap.get("DETAILINFO"));
            transactionDetailDTOList.add(transactionDetailDTO);
        } else {
            ArrayList detailinfoMapList = (ArrayList)responseBodyMap.get("DETAILINFO");
            detailinfoMapList.forEach(jj -> {
                TransactionDetailDTO transactionDetailDTO = new TransactionDetailDTO();
                CCBServiceImpl.fillObjectValue(transactionDetailDTO, (Map)jj);
                transactionDetailDTOList.add(transactionDetailDTO);
            });
        }
        return transactionDetailResponse;
    }

    public TransactionDetailsInquiryFileDownloadResponse transactionDetailsInquiryFileDownload(TransactionDetailsInquiryFileDownloadRequest transactionDetailsInquiryFileDownloadRequest) {
        CCBResponseBase ccbResponseBase;
        TransactionDetailsInquiryFileDownloadResponse transactionDetailsInquiryFileDownloadResponse;
        block2: {
            transactionDetailsInquiryFileDownloadResponse = new TransactionDetailsInquiryFileDownloadResponse();
            transactionDetailsInquiryFileDownloadRequest.setCcbRequestHead(this.getCcbRequestHead());
            transactionDetailsInquiryFileDownloadRequest.getCcbRequestHead().setTxCode("download");
            ccbResponseBase = new CCBResponseBase();
            transactionDetailsInquiryFileDownloadResponse.setCcbResponseBase(ccbResponseBase);
            try {
                this.downloadFileSftp(transactionDetailsInquiryFileDownloadRequest.getFileName());
            }
            catch (JschRuntimeException ex) {
                if (!ex.getMessage().equalsIgnoreCase("SftpException: No such file")) break block2;
                ccbResponseBase.setReturnCode("000001");
                ccbResponseBase.setReturnMsg("No such file,\u8bf7\u786e\u8ba4\u6b64\u6587\u4ef6\u662f\u5426\u5df2\u7ecf\u751f\u6210");
                return transactionDetailsInquiryFileDownloadResponse;
            }
        }
        List<TransactionDetailFileDTO> transactionDetailDTOList = this.analyzingFileContent(transactionDetailsInquiryFileDownloadRequest.getFileName());
        transactionDetailsInquiryFileDownloadResponse.setTransactionDetailFileDTOList(transactionDetailDTOList);
        ccbResponseBase.setReturnCode("000000");
        return transactionDetailsInquiryFileDownloadResponse;
    }

    public List<TransactionDetailFileDTO> analyzingFileContent(String fileName) {
        File file = new File(fileName);
        ArrayList transactionDetailFileDTOList = Lists.newArrayList();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String lineStr;
            while ((lineStr = bufferedReader.readLine()) != null) {
                String[] filed = StrUtil.split((CharSequence)lineStr, (CharSequence)"|@|");
                if (filed == null || filed.length == 0) continue;
                this.genTransactionDetailDTO(transactionDetailFileDTOList, filed);
            }
        }
        catch (IOException e) {
            log.error("analyzingFileContent fail,{}", (Throwable)e);
        }
        log.info("analyzingFileContent transactionDetailFileDTOList size:{}", (Object)transactionDetailFileDTOList.size());
        file.delete();
        return transactionDetailFileDTOList;
    }

    private void genTransactionDetailDTO(List<TransactionDetailFileDTO> transactionDetailFileDTOList, String[] filed) {
        TransactionDetailFileDTO transactionDetailFileDTO = new TransactionDetailFileDTO();
        transactionDetailFileDTO.setTranDate(filed[0]);
        transactionDetailFileDTO.setTranTime(filed[1]);
        transactionDetailFileDTO.setCreType(filed[2]);
        transactionDetailFileDTO.setCreNo(filed[3]);
        transactionDetailFileDTO.setMessage(filed[4]);
        transactionDetailFileDTO.setAmt(filed[5]);
        transactionDetailFileDTO.setAmt1(filed[6]);
        transactionDetailFileDTO.setFlag1(filed[7]);
        transactionDetailFileDTO.setAccNo2(filed[8]);
        transactionDetailFileDTO.setAccName1(filed[9]);
        transactionDetailFileDTO.setFlag2(filed[10]);
        transactionDetailFileDTO.setTranFlow(filed[11]);
        transactionDetailFileDTO.setBFlow(filed[12]);
        transactionDetailFileDTO.setDetNo(filed[13]);
        transactionDetailFileDTO.setDet(filed[14]);
        transactionDetailFileDTO.setOutDet(filed[15]);
        transactionDetailFileDTO.setRltvAccNo(filed[18]);
        transactionDetailFileDTO.setCadBankNm(filed[17]);
        transactionDetailFileDTOList.add(transactionDetailFileDTO);
    }

    public void downloadFileSftp(String fileName) {
        Sftp sftp = new Sftp(this.sshHost, this.sshPort.intValue(), this.sshUser, this.sshPass);
        sftp.init();
        sftp.get(fileName, "");
    }

    public TransactionDetailInquiryFileResponse transactionDetailsInquiryFileRequest(TransactionDetailInquiryFileRequest transactionDetailInquiryFileRequest) {
        transactionDetailInquiryFileRequest.setCcbRequestHead(this.getCcbRequestHead());
        transactionDetailInquiryFileRequest.getCcbRequestHead().setTxCode("6WY102");
        Map<String, String> requestHeadMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileRequest.getCcbRequestHead());
        Map<String, String> requestBodyMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileRequest);
        String requestXml = CCBServiceImpl.buildRequestXml(requestHeadMap, requestBodyMap);
        String responseXml = this.sendHttp(requestXml);
        TransactionDetailInquiryFileResponse transactionDetailInquiryFileResponse = new TransactionDetailInquiryFileResponse();
        CCBServiceImpl.responseToObject(responseXml, transactionDetailInquiryFileResponse);
        return transactionDetailInquiryFileResponse;
    }

    public TransactionDetailInquiryFileProcessResponse transactionDetailsInquiryFileProcess(TransactionDetailInquiryFileProcessRequest transactionDetailInquiryFileProcessRequest) {
        transactionDetailInquiryFileProcessRequest.setCcbRequestHead(this.getCcbRequestHead());
        transactionDetailInquiryFileProcessRequest.getCcbRequestHead().setTxCode("6WY103");
        transactionDetailInquiryFileProcessRequest.setFlag("1");
        transactionDetailInquiryFileProcessRequest.setFileMode("1");
        Map<String, String> requestHeadMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileProcessRequest.getCcbRequestHead());
        Map<String, String> requestBodyMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileProcessRequest);
        String requestXml = CCBServiceImpl.buildRequestXml(requestHeadMap, requestBodyMap);
        String responseXml = this.sendHttp(requestXml);
        final TransactionDetailInquiryFileProcessResponse transactionDetailInquiryFileProcessResponse = new TransactionDetailInquiryFileProcessResponse();
        CCBServiceImpl.responseToObject(responseXml, transactionDetailInquiryFileProcessResponse);
        if (transactionDetailInquiryFileProcessResponse.getCcbResponseBase().getReturnCode().equalsIgnoreCase("000000") && transactionDetailInquiryFileProcessResponse.getStatus().equalsIgnoreCase("0")) {
            Thread downloadThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TransactionDetailInquiryFileProcessRequest transactionDetailInquiryFileProcessRequest = new TransactionDetailInquiryFileProcessRequest();
                    transactionDetailInquiryFileProcessRequest.setFileLocStr(transactionDetailInquiryFileProcessResponse.getFileName());
                    transactionDetailInquiryFileProcessRequest.setAccNo1(transactionDetailInquiryFileProcessRequest.getAccNo1());
                    TransactionDetailInquiryFileDowloadRequest transactionDetailInquiryFileDowloadRequest = new TransactionDetailInquiryFileDowloadRequest();
                    transactionDetailInquiryFileDowloadRequest.setSource(transactionDetailInquiryFileProcessResponse.getFileName());
                    transactionDetailInquiryFileDowloadRequest.setFilePath("B2B.customer.bill");
                    transactionDetailInquiryFileDowloadRequest.setLocalRemote("0");
                    CCBServiceImpl.this.fileDownload(transactionDetailInquiryFileDowloadRequest);
                }
            });
            downloadThread.start();
        }
        return transactionDetailInquiryFileProcessResponse;
    }

    public ElectronicReceiptResponse electronicReceiptInquiry(ElectronicReceiptRequest electronicReceiptRequest) {
        electronicReceiptRequest.setCcbRequestHead(this.getCcbRequestHead());
        electronicReceiptRequest.getCcbRequestHead().setTxCode("NWHD01");
        Map<String, String> requestHeadMap = CCBServiceImpl.getRequestBodyMap(electronicReceiptRequest.getCcbRequestHead());
        Map<String, String> requestBodyMap = CCBServiceImpl.getRequestBodyMap(electronicReceiptRequest);
        String requestXml = CCBServiceImpl.buildRequestXml(requestHeadMap, requestBodyMap);
        String responseXml = this.sendHttp(requestXml);
        ElectronicReceiptResponse electronicReceiptResponse = new ElectronicReceiptResponse();
        CCBServiceImpl.responseToObject(responseXml, electronicReceiptResponse);
        Map responseBodyMap = XmlUtil.xmlToMap((String)responseXml);
        responseBodyMap = (Map)responseBodyMap.get("TX_INFO");
        ArrayList transactionDetailDTOList = Lists.newArrayList();
        if (responseBodyMap.get("DETAILLIST") instanceof Map) {
            ElectronicReceiptDTO electronicReceiptDTO = new ElectronicReceiptDTO();
            CCBServiceImpl.fillObjectValue(electronicReceiptDTO, (Map)responseBodyMap.get("DETAILLIST"));
            transactionDetailDTOList.add(electronicReceiptDTO);
        } else {
            ArrayList xx = (ArrayList)responseBodyMap.get("DETAILLIST");
            xx.forEach(jj -> {
                ElectronicReceiptDTO electronicReceiptDTO = new ElectronicReceiptDTO();
                CCBServiceImpl.fillObjectValue(electronicReceiptDTO, (Map)jj);
                transactionDetailDTOList.add(electronicReceiptDTO);
            });
        }
        electronicReceiptResponse.setDetailList((List)transactionDetailDTOList);
        return electronicReceiptResponse;
    }

    public ElectronicReceiptProcessResponse electronicReceiptInquiryProcess(ElectronicReceiptProcessRequest transactionDetailInquiryFileDowloadRequest) {
        transactionDetailInquiryFileDowloadRequest.setCcbRequestHead(this.getCcbRequestHead());
        transactionDetailInquiryFileDowloadRequest.getCcbRequestHead().setTxCode("NWHD02");
        Map<String, String> requestHeadMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileDowloadRequest.getCcbRequestHead());
        Map<String, String> requestBodyMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileDowloadRequest);
        String requestXml = CCBServiceImpl.buildRequestXml(requestHeadMap, requestBodyMap);
        String responseXml = this.sendHttp(requestXml);
        ElectronicReceiptProcessResponse electronicReceiptProcessResponse = new ElectronicReceiptProcessResponse();
        CCBServiceImpl.responseToObject(responseXml, electronicReceiptProcessResponse);
        return electronicReceiptProcessResponse;
    }

    public ElectronicReceiptFileDowloadResponse electronicReceiptInquiryFileDownload(ElectronicReceiptFileDowlandRequest transactionDetailInquiryFileDowloadRequest) {
        transactionDetailInquiryFileDowloadRequest.setCcbRequestHead(this.getCcbRequestHead());
        Map<String, String> requestHeadMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileDowloadRequest.getCcbRequestHead());
        Map<String, String> requestBodyMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileDowloadRequest);
        String requestXml = CCBServiceImpl.buildRequestXml(requestHeadMap, requestBodyMap);
        String responseXml = this.sendHttp(requestXml);
        ElectronicReceiptFileDowloadResponse electronicReceiptFileDowloadResponse = new ElectronicReceiptFileDowloadResponse();
        CCBServiceImpl.responseToObject(responseXml, electronicReceiptFileDowloadResponse);
        return electronicReceiptFileDowloadResponse;
    }

    public TransactionDetailInquiryFileDowloadResponse fileDownload(TransactionDetailInquiryFileDowloadRequest transactionDetailInquiryFileDowloadRequest) {
        transactionDetailInquiryFileDowloadRequest.setCcbRequestHead(this.getCcbRequestHead());
        transactionDetailInquiryFileDowloadRequest.getCcbRequestHead().setTxCode("6W0111");
        Map<String, String> requestHeadMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileDowloadRequest.getCcbRequestHead());
        Map<String, String> requestBodyMap = CCBServiceImpl.getRequestBodyMap(transactionDetailInquiryFileDowloadRequest);
        String requestXml = CCBServiceImpl.buildRequestXml(requestHeadMap, requestBodyMap);
        String responseXml = this.sendHttp(requestXml);
        TransactionDetailInquiryFileDowloadResponse transactionDetailInquiryFileDowloadResponse = new TransactionDetailInquiryFileDowloadResponse();
        CCBServiceImpl.responseToObject(responseXml, transactionDetailInquiryFileDowloadResponse);
        return transactionDetailInquiryFileDowloadResponse;
    }

    private CCBRequestHead getCcbRequestHead() {
        DateTime dateTime = new DateTime();
        String requestSN = dateTime.toString((DatePrinter)DatePattern.PURE_DATETIME_FORMAT);
        CCBRequestHead ccbRequestHead = new CCBRequestHead();
        ccbRequestHead.setCustId(this.custId);
        ccbRequestHead.setRequestSN(requestSN);
        ccbRequestHead.setUserId(this.userId);
        ccbRequestHead.setPassword(this.password);
        ccbRequestHead.setLanguage(this.language);
        return ccbRequestHead;
    }

    public static void responseToObject(String responseBody, Object object) {
        Map responseBodyMap = XmlUtil.xmlToMap((String)responseBody);
        CCBResponseBase ccbResponseBase = new CCBResponseBase();
        CCBServiceImpl.fillObjectValue(ccbResponseBase, responseBodyMap);
        String retrunCode = (String)responseBodyMap.get("RETURN_CODE");
        if (retrunCode.equalsIgnoreCase("000000")) {
            responseBodyMap = (Map)responseBodyMap.get("TX_INFO");
            CCBServiceImpl.fillObjectValue(object, responseBodyMap);
        }
        try {
            Field ccbResponseBaseField = object.getClass().getDeclaredField("ccbResponseBase");
            ccbResponseBaseField.setAccessible(true);
            ccbResponseBaseField.set(object, ccbResponseBase);
        }
        catch (Exception e) {
            log.error("responseToObject is error {}", (Throwable)e);
        }
    }

    private static void fillObjectValue(Object object, Map<String, Object> responseBodyMap) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            try {
                ApiParam annotation = field.getAnnotation(ApiParam.class);
                if (!(annotation instanceof ApiParam)) continue;
                String keyName = annotation.name();
                field.setAccessible(true);
                field.set(object, responseBodyMap.get(keyName));
            }
            catch (IllegalAccessException e) {
                log.error("getRequestBodyMap is error {}", (Throwable)e);
            }
        }
    }

    public static Map<String, String> getRequestBodyMap(Object requestBody) {
        Field[] fields;
        HashMap requestMap = Maps.newHashMap();
        for (Field field : fields = requestBody.getClass().getDeclaredFields()) {
            try {
                ApiParam annotation = field.getAnnotation(ApiParam.class);
                if (!(annotation instanceof ApiParam)) continue;
                field.setAccessible(true);
                String value = (String)field.get(requestBody);
                requestMap.put(annotation.name(), value);
            }
            catch (IllegalAccessException e) {
                log.error("getRequestBodyMap is error {}", (Throwable)e);
            }
        }
        return requestMap;
    }

    public static String buildRequestXml(Map<String, String> requestHeadMap, Map<String, String> requestBodyMap) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document tx = documentBuilder.newDocument();
            Element root = tx.createElement("TX");
            tx.appendChild(root);
            for (Map.Entry<String, String> entry : requestHeadMap.entrySet()) {
                Element element = tx.createElement(entry.getKey());
                element.setTextContent(entry.getValue());
                root.appendChild(element);
            }
            Element txInfo = tx.createElement("TX_INFO");
            root.appendChild(txInfo);
            for (Map.Entry<String, String> entry : requestBodyMap.entrySet()) {
                Element element = tx.createElement(entry.getKey());
                element.setTextContent(entry.getValue());
                txInfo.appendChild(element);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "GB2312");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("version", "1.1");
            transformer.transform(new DOMSource(root), new StreamResult(byteArrayOutputStream));
            return byteArrayOutputStream.toString("GB2312");
        }
        catch (Exception e) {
            log.error("buildRequestXml error : {}", (Throwable)e);
            return "";
        }
    }

    public String sendHttp(String requestXml) {
        String response = null;
        try {
            String requestXmlGB2312 = new String(requestXml.getBytes("GB18030"), "GB18030");
            response = this.post(requestXmlGB2312);
        }
        catch (Exception e) {
            log.error("sendHttp error->{}", (Throwable)e);
        }
        return response;
    }

    public String post(String requestXml) throws IOException {
        OkHttpClient client = new OkHttpClient();
        FormBody formBody = new FormBody.Builder().add("requestXml", requestXml).build();
        Request request = new Request.Builder().url(this.url).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*").addHeader("Accept-Encoding", "gzip, deflate").addHeader("Accept-Language", "zh-cn").post((RequestBody)formBody).build();
        Call call = client.newCall(request);
        Response response = call.execute();
        return this.decodeString(response);
    }

    private String decodeString(Response response) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.body().byteStream(), "GB18030"));
        StringBuilder responseStr = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            responseStr.append(line);
        }
        return responseStr.toString();
    }

    public String getCustId() {
        return this.custId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSshHost() {
        return this.sshHost;
    }

    public Integer getSshPort() {
        return this.sshPort;
    }

    public String getSshUser() {
        return this.sshUser;
    }

    public String getSshPass() {
        return this.sshPass;
    }

    public String getUrl() {
        return this.url;
    }
}

