/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.impl.qcc;

import com.xforceplus.finance.dvas.common.accModel.qcc.basicDetailInfo.BasicDetailInfoResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.companyWebSite.CompanyWebSiteResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIBranch.ECIBranchResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIChange.ECIChangeResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIEmployee.ECIEmployeeResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIInfoOverview.ECIInfoOverviewResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIPartner.ECIPartnerReponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.equityThrough.EquityThroughInfo;
import com.xforceplus.finance.dvas.common.accModel.qcc.exceptionCheck.ExceptionCheckInfo;
import com.xforceplus.finance.dvas.common.accModel.qcc.exceptionCheck.ExceptionCheckResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.judgmentDoc.SearchJudgmentDocResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.searchPhone.SearchPhoneResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxCredit.TaxCreditResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheck.TaxOweNoticeCheckInfo;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheckDetail.TaxOweNoticeCheckDetailResponseData;
import com.xforceplus.finance.dvas.common.api.qcc.CompanyContext;
import com.xforceplus.finance.dvas.common.convert.IQccDTOConvert;
import com.xforceplus.finance.dvas.common.entity.company.CompanyBranch;
import com.xforceplus.finance.dvas.common.entity.company.CompanyChangeInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyContactInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyEmployeeInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyEquityThrough;
import com.xforceplus.finance.dvas.common.entity.company.CompanyException;
import com.xforceplus.finance.dvas.common.entity.company.CompanyJudgmentDoc;
import com.xforceplus.finance.dvas.common.entity.company.CompanyOverviewInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyPartner;
import com.xforceplus.finance.dvas.common.entity.company.CompanyTaxInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyTaxOweDetailInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyTaxOweInfo;
import com.xforceplus.finance.dvas.common.entity.company.CompanyWebSite;
import com.xforceplus.finance.dvas.common.repository.company.CompanyBranchMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyChangeInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyContactInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyDetailInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyEmployeeInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyEquityThroughMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyExceptionMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyJudgmentDocMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyOverviewInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyPartnerMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyTaxInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyTaxOweDetailInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyTaxOweInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyWebSiteMapper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QccRepository {
    private static final Logger log = LoggerFactory.getLogger(QccRepository.class);
    @Autowired
    private CompanyBranchMapper companyBranchMapper;
    @Autowired
    private CompanyChangeInfoMapper companyChangeInfoMapper;
    @Autowired
    private CompanyContactInfoMapper companyContactInfoMapper;
    @Autowired
    private CompanyDetailInfoMapper companyDetailInfoMapper;
    @Autowired
    private CompanyEquityThroughMapper companyEquityThroughMapper;
    @Autowired
    private CompanyExceptionMapper companyExceptionMapper;
    @Autowired
    private CompanyJudgmentDocMapper companyJudgmentDocMapper;
    @Autowired
    private CompanyPartnerMapper companyPartnerMapper;
    @Autowired
    private CompanyTaxInfoMapper companyTaxInfoMapper;
    @Autowired
    private CompanyTaxOweDetailInfoMapper companyTaxOweDetailInfoMapper;
    @Autowired
    private CompanyTaxOweInfoMapper companyTaxOweInfoMapper;
    @Autowired
    private CompanyWebSiteMapper companyWebSiteMapper;
    @Autowired
    private IQccDTOConvert qccDTOConvert;
    @Autowired
    private CompanyEmployeeInfoMapper companyEmployeeInfoMapper;
    @Autowired
    private CompanyOverviewInfoMapper companyOverviewInfoMapper;
    @Value(value="${qcc.commonType}")
    private Integer commonType;

    public Boolean saveOrUpdateBasicDetailInfo(BasicDetailInfoResponseData basicDetailInfoResponseData, CompanyContext companyContext) {
        return true;
    }

    public Boolean saveOrUpdatePartner(List<ECIPartnerReponseData> eciPartnerReponseDataList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyPartnerMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            this.companyPartnerMapper.deleteByCompanyRecordId(companyContext.getCompanyRecordId());
            eciPartnerReponseDataList.forEach(tempEciPartnerReponseData -> {
                CompanyPartner companyPartner = this.qccDTOConvert.toCompanyPartner((ECIPartnerReponseData)tempEciPartnerReponseData, companyContext);
                this.companyPartnerMapper.insert((Object)companyPartner);
            });
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u80a1\u4e1c\u5217\u8868-\u4fdd\u5b58\u5f02\u5e38:.{}", (Throwable)e);
            throw e;
        }
        return true;
    }

    public Boolean saveOrUpdateBranch(List<ECIBranchResponseData> eciBranchResponseDataList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyBranchMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            this.companyBranchMapper.deleteByCompanyRecordId(companyContext.getCompanyRecordId());
            eciBranchResponseDataList.forEach(tempEciPartnerReponseData -> {
                CompanyBranch companyBranch = this.qccDTOConvert.toCompanyBranch((ECIBranchResponseData)tempEciPartnerReponseData, companyContext);
                this.companyBranchMapper.insert((Object)companyBranch);
            });
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u5206\u652f\u673a\u6784-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        return true;
    }

    public Boolean saveOrUpdateCompanyChange(List<ECIChangeResponseData> eciChangeResponseDataList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyChangeInfoMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            this.companyChangeInfoMapper.deleteByCompanyRecordId(companyContext.getCompanyRecordId());
            eciChangeResponseDataList.forEach(tempECIChangeResponseData -> {
                CompanyChangeInfo companyChangeInfo = this.qccDTOConvert.toCompanyChangeInfo((ECIChangeResponseData)tempECIChangeResponseData, companyContext);
                this.companyChangeInfoMapper.insert((Object)companyChangeInfo);
            });
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u53d8\u66f4\u8bb0\u5f55-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        return true;
    }

    public Boolean saveCompanyEmployeeInfo(List<ECIEmployeeResponseData> employeeResponseDataList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyEmployeeInfoMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            employeeResponseDataList.forEach(item -> {
                CompanyEmployeeInfo companyEmployeeInfo = this.qccDTOConvert.toCompanyEmployeeInfo((ECIEmployeeResponseData)item, companyContext);
                this.companyEmployeeInfoMapper.insertOrUpdate(companyEmployeeInfo);
            });
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u4e3b\u8981\u4eba\u5458-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        return true;
    }

    public Boolean saveOrUpdateEquityThrough(List<EquityThroughInfo> equityThroughInfoList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyEquityThroughMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            this.companyEquityThroughMapper.deleteByCompanyRecordId(companyContext.getCompanyRecordId());
            equityThroughInfoList.forEach(item -> {
                CompanyEquityThrough companyEquityThrough = this.qccDTOConvert.toCompanyEquityThrough((EquityThroughInfo)item, companyContext);
                this.companyEquityThroughMapper.insert((Object)companyEquityThrough);
            });
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u80a1\u6743\u7a7f\u900f\u63a5\u53e3-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        return true;
    }

    public Boolean saveOrUpdateCompanyException(ExceptionCheckResponseData exceptionCheckResponseData, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyExceptionMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            this.companyExceptionMapper.deleteByCompanyRecordId(companyContext.getCompanyRecordId());
            exceptionCheckResponseData.getData().forEach(tempExceptionCheckInfo -> {
                CompanyException companyException = this.qccDTOConvert.toCompanyException((ExceptionCheckInfo)tempExceptionCheckInfo, companyContext);
                this.companyExceptionMapper.insert((Object)companyException);
            });
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u7ecf\u8425\u5f02\u5e38\u6838\u67e5-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        return true;
    }

    public Boolean saveCompanyTaxOweInfo(List<TaxOweNoticeCheckInfo> taxOweNoticeCheckInfoList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyTaxOweInfoMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            taxOweNoticeCheckInfoList.forEach(item -> {
                CompanyTaxOweInfo companyTaxOweInfo = this.qccDTOConvert.toCompanyTaxOweInfo((TaxOweNoticeCheckInfo)item, companyContext);
                this.companyTaxOweInfoMapper.insertOrUpdate(companyTaxOweInfo);
            });
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u6b20\u7a0e\u516c\u544a\u6838\u67e5-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        return true;
    }

    public Boolean saveCompanyTaxOweDetailInfo(TaxOweNoticeCheckDetailResponseData taxOweNoticeCheckDetailResponseData, CompanyContext companyContext) {
        try {
            CompanyTaxOweDetailInfo companyTaxOweDetailInfo;
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyTaxOweDetailInfoMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            return this.companyTaxOweDetailInfoMapper.insertOrUpdate(companyTaxOweDetailInfo = this.qccDTOConvert.toCompanyTaxOweDetailInfo(taxOweNoticeCheckDetailResponseData, companyContext)) > 0;
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u6b20\u7a0e\u516c\u544a\u8be6\u60c5-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
    }

    public Boolean saveCompanyOverviewInfo(ECIInfoOverviewResponseData overviewResponseData, CompanyContext companyContext) {
        try {
            CompanyOverviewInfo companyOverviewInfo;
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyOverviewInfoMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            return this.companyOverviewInfoMapper.insertOrUpdate(companyOverviewInfo = this.qccDTOConvert.toCompanyOverviewInfo(overviewResponseData, companyContext)) > 0;
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u6b20\u7a0e\u516c\u544a\u8be6\u60c5-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
    }

    public Boolean saveCompanyJudgmentDoc(List<SearchJudgmentDocResponseData> judgmentDocResponseDataList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyJudgmentDocMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            judgmentDocResponseDataList.forEach(item -> {
                CompanyJudgmentDoc companyJudgmentDoc = this.qccDTOConvert.toCompanyJudgmentDoc((SearchJudgmentDocResponseData)item, companyContext);
                this.companyJudgmentDocMapper.insertOrUpdate(companyJudgmentDoc);
            });
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u88c1\u5224\u6587\u4e66\u67e5\u8be2-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        return true;
    }

    public Boolean saveCompanyWebSite(List<CompanyWebSiteResponseData> companyWebSiteResponseDataList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyWebSiteMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            this.companyWebSiteMapper.deleteByCompanyRecordIdOrTaxNum(companyContext.getCompanyRecordId(), companyContext.getTaxNum());
            ArrayList companyTaxInfoList = new ArrayList();
            companyWebSiteResponseDataList.forEach(item -> {
                CompanyWebSite companyWebSite = this.qccDTOConvert.toCompanyWebSite((CompanyWebSiteResponseData)item, companyContext);
                companyTaxInfoList.add(companyWebSite);
            });
            return this.companyWebSiteMapper.batchInsert(companyTaxInfoList) > 0;
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u516c\u53f8\u7f51\u7ad9\u4fe1\u606f-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
    }

    public Boolean saveCompanyTaxInfo(List<TaxCreditResponseData> taxCreditResponseDataList, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyTaxInfoMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            this.companyTaxInfoMapper.deleteByCompanyRecordIdOrTaxNum(companyContext.getCompanyRecordId(), companyContext.getTaxNum());
            ArrayList companyTaxInfoList = new ArrayList();
            taxCreditResponseDataList.forEach(item -> {
                CompanyTaxInfo companyTaxInfo = this.qccDTOConvert.toCompanyTaxInfo((TaxCreditResponseData)item, companyContext);
                companyTaxInfoList.add(companyTaxInfo);
            });
            return this.companyTaxInfoMapper.batchInsert(companyTaxInfoList) > 0;
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u7a0e\u52a1\u4fe1\u7528-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
    }

    public Boolean saveCompanyContactInfo(List<SearchPhoneResponseData> listSearchPhoneResponseData, CompanyContext companyContext) {
        try {
            if (companyContext.getCurrentVersion() == null) {
                companyContext.setCurrentVersion(this.companyContactInfoMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
            }
            this.companyContactInfoMapper.deleteByCompanyRecordIdOrTaxNum(companyContext.getCompanyRecordId(), companyContext.getTaxNum());
            ArrayList companyContactInfoList = new ArrayList();
            listSearchPhoneResponseData.forEach(item -> {
                CompanyContactInfo companyContactInfo = this.qccDTOConvert.toCompanyContactInfo((SearchPhoneResponseData)item, companyContext);
                companyContactInfoList.add(companyContactInfo);
            });
            this.companyContactInfoMapper.batchInsert(companyContactInfoList);
        }
        catch (Exception e) {
            log.error("[\u4f01\u67e5\u67e5]-\u8054\u7cfb\u4fe1\u606f\u67e5\u8be2-\u4fdd\u5b58\u5f02\u5e38:{}", (Throwable)e);
            throw e;
        }
        return true;
    }
}

