/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.impl.qcc;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.api.client.util.Lists;
import com.xforceplus.finance.dvas.common.accModel.qcc.QccResultBaseModel;
import com.xforceplus.finance.dvas.common.accModel.qcc.basicDetailInfo.BasicDetailInfoResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.basicDetailInfo.BasicDetailInfoResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.companyWebSite.CompanyWebSiteResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.companyWebSite.CompanyWebSiteResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.copyRight.CopyRightDTO;
import com.xforceplus.finance.dvas.common.accModel.qcc.copyRight.CopyRightInfoResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIBranch.ECIBranchResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIBranch.ECIBranchResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIChange.ECIChangeResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIChange.ECIChangeResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIEmployee.ECIEmployeeResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIEmployee.ECIEmployeeResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIInfoOverview.ECIInfoOverviewResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIInfoOverview.ECIInfoOverviewResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIPartner.ECIPartnerReponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIPartner.ECIPartnerReponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.equityThrough.EquityThroughResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.equityThrough.EquityThroughResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.exceptionCheck.ExceptionCheckResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.exceptionCheck.ExceptionCheckResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.icp.ICPInfoDTO;
import com.xforceplus.finance.dvas.common.accModel.qcc.icp.ICPInfoResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.judgementDetail.JudgementDetailResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.judgementDetail.JudgementDetailResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.judgmentDoc.SearchJudgmentDocResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.judgmentDoc.SearchJudgmentDocResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.searchPhone.SearchPhoneResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.searchPhone.SearchPhoneResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxCredit.TaxCreditResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxCredit.TaxCreditResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheck.TaxOweNoticeCheckResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheck.TaxOweNoticeCheckResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheckDetail.TaxOweNoticeCheckDetailResponse;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheckDetail.TaxOweNoticeCheckDetailResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.tm.TMInfoDTO;
import com.xforceplus.finance.dvas.common.accModel.qcc.tm.TMInfoResponseData;
import com.xforceplus.finance.dvas.common.api.qcc.CompanyContext;
import com.xforceplus.finance.dvas.common.api.qcc.QccBusinessApi;
import com.xforceplus.finance.dvas.common.constant.qcc.QccApiEnum;
import com.xforceplus.finance.dvas.common.convert.format.CompanyConverter;
import com.xforceplus.finance.dvas.common.dto.CompanyAutoFillInfoDto;
import com.xforceplus.finance.dvas.common.repository.company.CompanyBranchMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyChangeInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyContactInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyDetailInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyEmployeeInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyEquityThroughMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyExceptionMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyJudgmentDocMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyOverviewInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyPartnerMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyTaxInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyTaxOweDetailInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyTaxOweInfoMapper;
import com.xforceplus.finance.dvas.common.repository.company.CompanyWebSiteMapper;
import com.xforceplus.finance.dvas.common.service.api.qcc.QichachaApi;
import com.xforceplus.finance.dvas.common.service.impl.qcc.QccRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QichachaApiImpl
implements QichachaApi {
    private static final Logger log = LoggerFactory.getLogger(QichachaApiImpl.class);
    @Autowired
    private QccBusinessApi qccBusinessApi;
    @Autowired
    private QccRepository qccRepository;
    @Value(value="${qcc.getEquityThroughLevel}")
    private Integer getEquityThroughLevel;
    @Autowired
    private CompanyBranchMapper companyBranchMapper;
    @Autowired
    private CompanyChangeInfoMapper companyChangeInfoMapper;
    @Autowired
    private CompanyContactInfoMapper companyContactInfoMapper;
    @Autowired
    private CompanyDetailInfoMapper companyDetailInfoMapper;
    @Autowired
    private CompanyEquityThroughMapper companyEquityThroughMapper;
    @Autowired
    private CompanyExceptionMapper companyExceptionMapper;
    @Autowired
    private CompanyJudgmentDocMapper companyJudgmentDocMapper;
    @Autowired
    private CompanyPartnerMapper companyPartnerMapper;
    @Autowired
    private CompanyTaxInfoMapper companyTaxInfoMapper;
    @Autowired
    private CompanyTaxOweDetailInfoMapper companyTaxOweDetailInfoMapper;
    @Autowired
    private CompanyTaxOweInfoMapper companyTaxOweInfoMapper;
    @Autowired
    private CompanyWebSiteMapper companyWebSiteMapper;
    @Autowired
    private CompanyEmployeeInfoMapper companyEmployeeInfoMapper;
    @Autowired
    private CompanyOverviewInfoMapper companyOverviewInfoMapper;
    @Autowired
    private CompanyConverter companyConverter;

    @Override
    public Boolean notifyVAT() {
        return null;
    }

    @Override
    public Boolean syncCompanyInfoFromQccByTaxNum(List<String> taxNumList) {
        if (CollectionUtils.isEmpty(taxNumList)) {
            log.info("companyRecordIdList is null");
            return false;
        }
        return true;
    }

    @Override
    public Boolean syncCompanyInfoFromQcc(CompanyContext companyContext) {
        try {
            this.getBasicDetailsByName(companyContext.getCompanyName(), companyContext);
            this.getECIPartner(companyContext.getCompanyName(), companyContext);
            this.getECIBranch(companyContext.getCompanyName(), companyContext);
            this.getECIChange(companyContext.getCompanyName(), companyContext);
            this.getECIEmployee(companyContext.getCompanyName(), companyContext);
            this.getEquityThrough(companyContext.getCompanyName(), companyContext);
            this.getExceptionCheck(companyContext.getCompanyName(), companyContext);
            TaxOweNoticeCheckResponseData taxOweNoticeCheckResponseData = this.getTaxOweNoticeCheck(companyContext.getCompanyName(), companyContext);
            if (taxOweNoticeCheckResponseData != null && taxOweNoticeCheckResponseData.getData() != null && taxOweNoticeCheckResponseData.getData().size() > 0) {
                taxOweNoticeCheckResponseData.getData().forEach(item -> this.getTaxOweNoticeCheckDetail(item.getId(), companyContext));
            }
            this.searchJudgmentDoc(companyContext.getCompanyName(), companyContext);
            this.getCompanyWebSite(companyContext.getCompanyName(), companyContext);
            this.getTaxCredit(companyContext.getCompanyName(), companyContext);
            this.getPhoneInfo(companyContext.getCompanyName(), companyContext);
            return Boolean.TRUE;
        }
        catch (Exception ex) {
            log.error("\u540c\u6b65\u4f01\u67e5\u67e5\u5f02\u5e38:{}", (Throwable)ex);
            return Boolean.FALSE;
        }
    }

    @Override
    public BasicDetailInfoResponseData getBasicDetailsByName(String companyName, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("keyword", companyContext.getCompanyName());
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyDetailInfoMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        BasicDetailInfoResponse result = (BasicDetailInfoResponse)this.qccBusinessApi.get(QccApiEnum.BasicDetails, paramMap, BasicDetailInfoResponse.class, cloneCompanyContext);
        if (result != null) {
            if (result.getResult() != null) {
                this.qccRepository.saveOrUpdateBasicDetailInfo((BasicDetailInfoResponseData)result.getResult(), cloneCompanyContext);
            }
            return (BasicDetailInfoResponseData)result.getResult();
        }
        return null;
    }

    @Override
    public List<ECIPartnerReponseData> getECIPartner(String searchKey, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", searchKey);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "20");
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyPartnerMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        ECIPartnerReponse result = this.qccBusinessApi.getAll(QccApiEnum.ECIPartner, paramMap, ECIPartnerReponse.class, cloneCompanyContext);
        if (result != null) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)result.getResult()))) {
                this.qccRepository.saveOrUpdatePartner((List)result.getResult(), cloneCompanyContext);
            }
            return (List)result.getResult();
        }
        return null;
    }

    @Override
    public List<ECIBranchResponseData> getECIBranch(String searchKey, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", searchKey);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "20");
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyBranchMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        ECIBranchResponse result = this.qccBusinessApi.getAll(QccApiEnum.ECIBranch, paramMap, ECIBranchResponse.class, cloneCompanyContext);
        if (result != null) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)result.getResult()))) {
                this.qccRepository.saveOrUpdateBranch((List)result.getResult(), cloneCompanyContext);
            }
            return (List)result.getResult();
        }
        return null;
    }

    @Override
    public List<ECIChangeResponseData> getECIChange(String searchKey, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", searchKey);
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyChangeInfoMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        ECIChangeResponse result = (ECIChangeResponse)this.qccBusinessApi.get(QccApiEnum.ECIChange, paramMap, ECIChangeResponse.class, cloneCompanyContext);
        if (result != null) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)result.getResult()))) {
                this.qccRepository.saveOrUpdateCompanyChange((List)result.getResult(), cloneCompanyContext);
            }
            return (List)result.getResult();
        }
        return null;
    }

    @Override
    public List<ECIEmployeeResponseData> getECIEmployee(String searchKey, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", searchKey);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "20");
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyEmployeeInfoMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        ECIEmployeeResponse result = this.qccBusinessApi.getAll(QccApiEnum.ECIEmployee, paramMap, ECIEmployeeResponse.class, cloneCompanyContext);
        if (result != null) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)result.getResult()))) {
                this.qccRepository.saveCompanyEmployeeInfo((List)result.getResult(), cloneCompanyContext);
            }
            return (List)result.getResult();
        }
        return null;
    }

    @Override
    public EquityThroughResponseData getEquityThrough(String keyWord, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("keyword", keyWord);
        paramMap.put("level", this.getEquityThroughLevel.toString());
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyEquityThroughMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        EquityThroughResponse result = (EquityThroughResponse)this.qccBusinessApi.get(QccApiEnum.EquityThrough, paramMap, EquityThroughResponse.class, cloneCompanyContext);
        if (result != null) {
            if (result.getResult() != null && !CollectionUtils.isEmpty(((EquityThroughResponseData)result.getResult()).getChildren())) {
                this.qccRepository.saveOrUpdateEquityThrough(((EquityThroughResponseData)result.getResult()).getChildren(), cloneCompanyContext);
            }
            return (EquityThroughResponseData)result.getResult();
        }
        return null;
    }

    @Override
    public ExceptionCheckResponseData getExceptionCheck(String searchKey, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", searchKey);
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyExceptionMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        ExceptionCheckResponse result = (ExceptionCheckResponse)this.qccBusinessApi.get(QccApiEnum.ExceptionCheck, paramMap, ExceptionCheckResponse.class, cloneCompanyContext);
        if (result != null) {
            if (result.getResult() != null && !CollectionUtils.isEmpty(((ExceptionCheckResponseData)result.getResult()).getData())) {
                this.qccRepository.saveOrUpdateCompanyException((ExceptionCheckResponseData)result.getResult(), cloneCompanyContext);
            }
            return (ExceptionCheckResponseData)result.getResult();
        }
        return null;
    }

    @Override
    public TaxOweNoticeCheckResponseData getTaxOweNoticeCheck(String searchKey, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", searchKey);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "20");
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyTaxOweInfoMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        TaxOweNoticeCheckResponse result = this.qccBusinessApi.getAll(QccApiEnum.TaxOweNoticeCheck_GetList, paramMap, TaxOweNoticeCheckResponse.class, cloneCompanyContext);
        if (result != null) {
            if (result.getResult() != null && !CollectionUtils.isEmpty(((TaxOweNoticeCheckResponseData)result.getResult()).getData())) {
                this.qccRepository.saveCompanyTaxOweInfo(((TaxOweNoticeCheckResponseData)result.getResult()).getData(), cloneCompanyContext);
            }
            return (TaxOweNoticeCheckResponseData)result.getResult();
        }
        return null;
    }

    @Override
    public TaxOweNoticeCheckDetailResponseData getTaxOweNoticeCheckDetail(String id, CompanyContext companyContext) {
        TaxOweNoticeCheckDetailResponse result;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", id);
        if (companyContext.getCurrentVersion() == null) {
            companyContext.setCurrentVersion(this.companyTaxOweDetailInfoMapper.getNextVersion(companyContext.getCompanyRecordId(), companyContext.getTaxNum()));
        }
        if ((result = (TaxOweNoticeCheckDetailResponse)this.qccBusinessApi.get(QccApiEnum.TaxOweNoticeCheck_GetDetail, paramMap, TaxOweNoticeCheckDetailResponse.class, companyContext)) != null) {
            if (result.getResult() != null) {
                this.qccRepository.saveCompanyTaxOweDetailInfo((TaxOweNoticeCheckDetailResponseData)result.getResult(), companyContext);
            }
            return (TaxOweNoticeCheckDetailResponseData)result.getResult();
        }
        return null;
    }

    @Override
    public ECIInfoOverviewResponseData getECIInfoOverview(String searchKey, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", searchKey);
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyOverviewInfoMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        ECIInfoOverviewResponse result = (ECIInfoOverviewResponse)this.qccBusinessApi.get(QccApiEnum.ECIInfoOverview, paramMap, ECIInfoOverviewResponse.class, cloneCompanyContext);
        if (result != null) {
            if (result.getResult() != null) {
                this.qccRepository.saveCompanyOverviewInfo((ECIInfoOverviewResponseData)result.getResult(), cloneCompanyContext);
            }
            return (ECIInfoOverviewResponseData)result.getResult();
        }
        return null;
    }

    @Override
    public List<SearchJudgmentDocResponseData> searchJudgmentDoc(String companyName, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", companyName);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "50");
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyJudgmentDocMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        SearchJudgmentDocResponse result = this.qccBusinessApi.getAll(QccApiEnum.SearchJudgmentDoc, paramMap, SearchJudgmentDocResponse.class, cloneCompanyContext);
        if (result != null) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)result.getResult()))) {
                this.qccRepository.saveCompanyJudgmentDoc((List)result.getResult(), cloneCompanyContext);
            }
            return (List)result.getResult();
        }
        return null;
    }

    @Override
    public JudgementDetailResponseData getJudgementDetail(String id, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", id);
        JudgementDetailResponse result = (JudgementDetailResponse)this.qccBusinessApi.get(QccApiEnum.GetJudgementDetail, paramMap, JudgementDetailResponse.class, companyContext);
        if (result != null) {
            return (JudgementDetailResponseData)result.getResult();
        }
        return null;
    }

    @Override
    public List<CompanyWebSiteResponseData> getCompanyWebSite(String taxNo, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", taxNo);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "50");
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyWebSiteMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        CompanyWebSiteResponse result = this.qccBusinessApi.getAll(QccApiEnum.GetCompanyWebSite, paramMap, CompanyWebSiteResponse.class, cloneCompanyContext);
        if (result != null) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)result.getResult()))) {
                this.qccRepository.saveCompanyWebSite((List)result.getResult(), cloneCompanyContext);
            }
            return (List)result.getResult();
        }
        return null;
    }

    @Override
    public List<TaxCreditResponseData> getTaxCredit(String taxNo, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", taxNo);
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyTaxInfoMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        TaxCreditResponse result = (TaxCreditResponse)this.qccBusinessApi.get(QccApiEnum.TaxCredit, paramMap, TaxCreditResponse.class, cloneCompanyContext);
        if (result != null) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)result.getResult()))) {
                this.qccRepository.saveCompanyTaxInfo((List)result.getResult(), cloneCompanyContext);
            }
            return (List)result.getResult();
        }
        return null;
    }

    @Override
    public List<SearchPhoneResponseData> getPhoneInfo(String taxNum, CompanyContext companyContext) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("keyword", taxNum);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "20");
        CompanyContext cloneCompanyContext = (CompanyContext)ObjectUtil.clone((Object)companyContext);
        cloneCompanyContext.setCurrentVersion(this.companyContactInfoMapper.getNextVersion(cloneCompanyContext.getCompanyRecordId(), cloneCompanyContext.getTaxNum()));
        SearchPhoneResponse result = this.qccBusinessApi.getAll(QccApiEnum.SearchPhone, paramMap, SearchPhoneResponse.class, cloneCompanyContext);
        if (result != null) {
            if (!CollectionUtils.isEmpty((Collection)((Collection)result.getResult()))) {
                this.qccRepository.saveCompanyContactInfo((List)result.getResult(), cloneCompanyContext);
            }
            return (List)result.getResult();
        }
        return null;
    }

    @Override
    public CompanyAutoFillInfoDto autoFillCompanyRegisterInfo(String companyId, String companyName, String taxNum) {
        CompanyContext companyContext = new CompanyContext();
        companyContext.setCompanyRecordId(Long.valueOf(companyId));
        companyContext.setTaxNum(taxNum);
        companyContext.setCompanyName(companyName);
        BasicDetailInfoResponseData result = this.getBasicDetailsByName(companyName, companyContext);
        return Optional.ofNullable(this.companyConverter.companyAutoFillToDto(result)).orElseGet(CompanyAutoFillInfoDto::new);
    }

    @Override
    public TMInfoResponseData getTMInfo(String taxNo, String companyName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("keyword", companyName);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "20");
        CompanyContext companyContext = new CompanyContext();
        companyContext.setCompanyRecordId(null);
        companyContext.setTaxNum(taxNo);
        companyContext.setCompanyName(companyName);
        QccResultBaseModel<Object> tmInfoResponseDataQccResultBaseModel = new QccResultBaseModel();
        tmInfoResponseDataQccResultBaseModel = this.qccBusinessApi.getAll(QccApiEnum.SearchTM, paramMap, tmInfoResponseDataQccResultBaseModel.getClass(), companyContext);
        log.info("tmInfoResponseDataQccResultBaseModel->{}", tmInfoResponseDataQccResultBaseModel);
        ArrayList tmInfoDTOList = Lists.newArrayList();
        if (tmInfoResponseDataQccResultBaseModel != null) {
            JSONArray jsonArray = (JSONArray)tmInfoResponseDataQccResultBaseModel.getResult();
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                String id = (String)jsonObject.get((Object)"Id");
                HashMap<String, String> detailParamMap = new HashMap<String, String>();
                detailParamMap.put("id", id);
                tmInfoResponseDataQccResultBaseModel = this.qccBusinessApi.get(QccApiEnum.SearchTMDetail, detailParamMap, tmInfoResponseDataQccResultBaseModel.getClass(), companyContext);
                log.info("tmInfoResponseDataQccResultBaseModel->{}", tmInfoResponseDataQccResultBaseModel);
                TMInfoDTO tmInfoDTO = (TMInfoDTO)((JSONObject)tmInfoResponseDataQccResultBaseModel.getResult()).toJavaObject(TMInfoDTO.class);
                tmInfoDTOList.add(tmInfoDTO);
            }
        }
        TMInfoResponseData tmInfoResponseData = new TMInfoResponseData();
        tmInfoResponseData.setName(companyName);
        tmInfoResponseData.setTmList(tmInfoDTOList);
        return tmInfoResponseData;
    }

    @Override
    public ICPInfoResponseData getICPInfo(String taxNo, String companyName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchkey", companyName);
        CompanyContext companyContext = new CompanyContext();
        companyContext.setCompanyRecordId(null);
        companyContext.setTaxNum(taxNo);
        companyContext.setCompanyName(companyName);
        QccResultBaseModel<Object> tmInfoResponseDataQccResultBaseModel = new QccResultBaseModel();
        tmInfoResponseDataQccResultBaseModel = this.qccBusinessApi.getAll(QccApiEnum.SearchICP, paramMap, tmInfoResponseDataQccResultBaseModel.getClass(), companyContext);
        log.info("tmInfoResponseDataQccResultBaseModel->{}", tmInfoResponseDataQccResultBaseModel);
        ArrayList icpInfoDTOS = Lists.newArrayList();
        if (tmInfoResponseDataQccResultBaseModel != null) {
            JSONArray jsonArray = (JSONArray)tmInfoResponseDataQccResultBaseModel.getResult();
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                String id = (String)jsonObject.get((Object)"Id");
                HashMap<String, String> detailParamMap = new HashMap<String, String>();
                detailParamMap.put("id", id);
                tmInfoResponseDataQccResultBaseModel = this.qccBusinessApi.get(QccApiEnum.SearchICPDetail, detailParamMap, tmInfoResponseDataQccResultBaseModel.getClass(), companyContext);
                log.info("tmInfoResponseDataQccResultBaseModel->{}", tmInfoResponseDataQccResultBaseModel);
                JSONObject jsonObjectDetail = (JSONObject)tmInfoResponseDataQccResultBaseModel.getResult();
                String abstractDesc = (String)jsonObjectDetail.get((Object)"Abstract");
                ICPInfoDTO icpInfoDTO = (ICPInfoDTO)((JSONObject)tmInfoResponseDataQccResultBaseModel.getResult()).toJavaObject(ICPInfoDTO.class);
                icpInfoDTO.setAbstractDesc(abstractDesc);
                icpInfoDTOS.add(icpInfoDTO);
            }
        }
        ICPInfoResponseData tmInfoResponseData = new ICPInfoResponseData();
        tmInfoResponseData.setName(companyName);
        tmInfoResponseData.setIpcList(icpInfoDTOS);
        return tmInfoResponseData;
    }

    @Override
    public CopyRightInfoResponseData getCopyRightInfo(String taxNo, String companyName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("searchKey", companyName);
        paramMap.put("pageIndex", "1");
        paramMap.put("pageSize", "20");
        CompanyContext companyContext = new CompanyContext();
        companyContext.setCompanyRecordId(null);
        companyContext.setTaxNum(taxNo);
        companyContext.setCompanyName(companyName);
        QccResultBaseModel<Object> tmInfoResponseDataQccResultBaseModel = new QccResultBaseModel();
        tmInfoResponseDataQccResultBaseModel = this.qccBusinessApi.getAll(QccApiEnum.SearchCopyRight, paramMap, tmInfoResponseDataQccResultBaseModel.getClass(), companyContext);
        log.info("tmInfoResponseDataQccResultBaseModel->{}", tmInfoResponseDataQccResultBaseModel);
        ArrayList copyRightList = Lists.newArrayList();
        if (tmInfoResponseDataQccResultBaseModel != null && tmInfoResponseDataQccResultBaseModel.getResult() != null) {
            JSONArray jsonArray = (JSONArray)tmInfoResponseDataQccResultBaseModel.getResult();
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                CopyRightDTO copyRightDTO = (CopyRightDTO)jsonObject.toJavaObject(CopyRightDTO.class);
                copyRightList.add(copyRightDTO);
            }
        }
        QccResultBaseModel<Object> softResponseDataQccResultBaseModel = new QccResultBaseModel();
        softResponseDataQccResultBaseModel = this.qccBusinessApi.getAll(QccApiEnum.SearchCopyRightSoft, paramMap, tmInfoResponseDataQccResultBaseModel.getClass(), companyContext);
        if (softResponseDataQccResultBaseModel != null && softResponseDataQccResultBaseModel.getResult() != null) {
            JSONArray jsonArray = (JSONArray)softResponseDataQccResultBaseModel.getResult();
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                CopyRightDTO copyRightDTO = (CopyRightDTO)jsonObject.toJavaObject(CopyRightDTO.class);
                copyRightList.add(copyRightDTO);
            }
        }
        CopyRightInfoResponseData copyRightInfoResponseData = new CopyRightInfoResponseData();
        copyRightInfoResponseData.setName(companyName);
        copyRightInfoResponseData.setCopyRightList(copyRightList);
        return copyRightInfoResponseData;
    }
}

