/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.kms;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.kms.model.v20160120.CreateKeyRequest;
import com.aliyuncs.kms.model.v20160120.CreateKeyResponse;
import com.aliyuncs.kms.model.v20160120.CreateSecretRequest;
import com.aliyuncs.kms.model.v20160120.CreateSecretResponse;
import com.aliyuncs.kms.model.v20160120.DecryptRequest;
import com.aliyuncs.kms.model.v20160120.DecryptResponse;
import com.aliyuncs.kms.model.v20160120.DescribeKeyRequest;
import com.aliyuncs.kms.model.v20160120.DescribeKeyResponse;
import com.aliyuncs.kms.model.v20160120.EncryptRequest;
import com.aliyuncs.kms.model.v20160120.EncryptResponse;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyRequest;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyResponse;
import com.aliyuncs.kms.model.v20160120.GetParametersForImportRequest;
import com.aliyuncs.kms.model.v20160120.GetParametersForImportResponse;
import com.aliyuncs.kms.model.v20160120.GetSecretValueRequest;
import com.aliyuncs.kms.model.v20160120.GetSecretValueResponse;
import com.aliyuncs.kms.model.v20160120.ImportKeyMaterialRequest;
import com.aliyuncs.kms.model.v20160120.ImportKeyMaterialResponse;
import com.aliyuncs.kms.model.v20160120.ListKeysRequest;
import com.aliyuncs.kms.model.v20160120.ListKeysResponse;
import com.aliyuncs.kms.model.v20160120.ListSecretsRequest;
import com.aliyuncs.kms.model.v20160120.ListSecretsResponse;
import com.aliyuncs.kms.model.v20160120.PutSecretValueRequest;
import com.aliyuncs.kms.model.v20160120.PutSecretValueResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.xml.bind.DatatypeConverter;

public class KmsClient {
    private DefaultAcsClient kmsClient;

    public static KmsClient getClientForPublicEndpoint(String regionId, String accessKeyId, String accessKeySecret) {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        return new KmsClient(client);
    }

    public static KmsClient getClientForVpcEndpoint(String regionId, String accessKeyId, String accessKeySecret, String endpoint) {
        DefaultProfile.addEndpoint((String)regionId, (String)"kms", (String)endpoint);
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        HttpClientConfig clientConfig = HttpClientConfig.getDefault();
        profile.setHttpClientConfig(clientConfig);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        return new KmsClient(client);
    }

    private KmsClient(DefaultAcsClient acsClient) {
        this.kmsClient = acsClient;
    }

    public CreateKeyResponse createKey(String keyDesc, String keyUsage) throws ClientException {
        CreateKeyRequest ckReq = new CreateKeyRequest();
        ckReq.setProtocol(ProtocolType.HTTPS);
        ckReq.setAcceptFormat(FormatType.JSON);
        ckReq.setMethod(MethodType.POST);
        ckReq.setDescription(keyDesc);
        ckReq.setKeyUsage(keyUsage);
        CreateKeyResponse response = (CreateKeyResponse)this.kmsClient.getAcsResponse((AcsRequest)ckReq);
        return response;
    }

    public DescribeKeyResponse describeKey(String keyId) throws ClientException {
        DescribeKeyRequest decKeyReq = new DescribeKeyRequest();
        decKeyReq.setProtocol(ProtocolType.HTTPS);
        decKeyReq.setAcceptFormat(FormatType.JSON);
        decKeyReq.setMethod(MethodType.POST);
        decKeyReq.setKeyId(keyId);
        DescribeKeyResponse decKeyRes = (DescribeKeyResponse)this.kmsClient.getAcsResponse((AcsRequest)decKeyReq);
        return decKeyRes;
    }

    public ListKeysResponse listKey(int pageNumber, int pageSize) throws ClientException {
        ListKeysRequest listKeysReq = new ListKeysRequest();
        listKeysReq.setProtocol(ProtocolType.HTTPS);
        listKeysReq.setAcceptFormat(FormatType.JSON);
        listKeysReq.setMethod(MethodType.POST);
        listKeysReq.setPageNumber(Integer.valueOf(pageNumber));
        listKeysReq.setPageSize(Integer.valueOf(pageSize));
        ListKeysResponse listKeysRes = (ListKeysResponse)this.kmsClient.getAcsResponse((AcsRequest)listKeysReq);
        return listKeysRes;
    }

    public GenerateDataKeyResponse generateDataKey(String keyId, String keyDesc, int numOfBytes) throws ClientException {
        GenerateDataKeyRequest genDKReq = new GenerateDataKeyRequest();
        genDKReq.setProtocol(ProtocolType.HTTPS);
        genDKReq.setAcceptFormat(FormatType.JSON);
        genDKReq.setMethod(MethodType.POST);
        genDKReq.setKeySpec(keyDesc);
        genDKReq.setKeyId(keyId);
        genDKReq.setNumberOfBytes(Integer.valueOf(numOfBytes));
        GenerateDataKeyResponse genDKRes = (GenerateDataKeyResponse)this.kmsClient.getAcsResponse((AcsRequest)genDKReq);
        return genDKRes;
    }

    public EncryptResponse encrypt(String keyId, String plainText) throws ClientException {
        EncryptRequest encReq = new EncryptRequest();
        encReq.setProtocol(ProtocolType.HTTPS);
        encReq.setAcceptFormat(FormatType.JSON);
        encReq.setMethod(MethodType.POST);
        encReq.setKeyId(keyId);
        encReq.setPlaintext(plainText);
        EncryptResponse encResponse = (EncryptResponse)this.kmsClient.getAcsResponse((AcsRequest)encReq);
        return encResponse;
    }

    public DecryptResponse decrypt(String cipherBlob) throws ClientException {
        DecryptRequest decReq = new DecryptRequest();
        decReq.setProtocol(ProtocolType.HTTPS);
        decReq.setAcceptFormat(FormatType.JSON);
        decReq.setMethod(MethodType.POST);
        decReq.setCiphertextBlob(cipherBlob);
        DecryptResponse decResponse = (DecryptResponse)this.kmsClient.getAcsResponse((AcsRequest)decReq);
        return decResponse;
    }

    public ImportKeyMaterialResponse createAndImportKey(String wrappingAlgorithm, String wrappingKeySpec) throws Exception {
        CreateKeyResponse keyResponse = this.createKey();
        String keyId = keyResponse.getKeyMetadata().getKeyId();
        byte[] keyMaterial = new byte[32];
        new Random().nextBytes(keyMaterial);
        GetParametersForImportResponse paramResponse = this.getParametersForImport(keyId, wrappingAlgorithm, wrappingKeySpec);
        String importToken = paramResponse.getImportToken();
        String encryptPublicKey = paramResponse.getPublicKey();
        byte[] publicKeyDer = DatatypeConverter.parseBase64Binary((String)encryptPublicKey);
        KeyFactory keyFact = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec spec = new X509EncodedKeySpec(publicKeyDer);
        PublicKey publicKey = keyFact.generatePublic(spec);
        Cipher oaepFromAlgo = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        String hashFunc = "SHA-256";
        OAEPParameterSpec oaepParams = new OAEPParameterSpec(hashFunc, "MGF1", new MGF1ParameterSpec(hashFunc), PSource.PSpecified.DEFAULT);
        oaepFromAlgo.init(1, (Key)publicKey, oaepParams);
        byte[] cipherDer = oaepFromAlgo.doFinal(keyMaterial);
        String encryptedKeyMaterial = DatatypeConverter.printBase64Binary((byte[])cipherDer);
        Long expireTimestamp = 0L;
        ImportKeyMaterialResponse response = this.importKeyMaterial(keyId, encryptedKeyMaterial, importToken, expireTimestamp);
        return response;
    }

    private ImportKeyMaterialResponse importKeyMaterial(String keyId, String encryptedKeyMaterial, String importToken, Long expireTimestamp) throws ClientException {
        ImportKeyMaterialRequest request = new ImportKeyMaterialRequest();
        request.setKeyId(keyId);
        request.setEncryptedKeyMaterial(encryptedKeyMaterial);
        request.setImportToken(importToken);
        request.setKeyMaterialExpireUnix(expireTimestamp);
        ImportKeyMaterialResponse response = (ImportKeyMaterialResponse)this.kmsClient.getAcsResponse((AcsRequest)request);
        return response;
    }

    public GetParametersForImportResponse getParametersForImport(String keyId, String wrappingAlgorithm, String wrappingKeySpec) throws ClientException {
        GetParametersForImportRequest request = new GetParametersForImportRequest();
        request.setKeyId(keyId);
        request.setWrappingAlgorithm(wrappingAlgorithm);
        request.setWrappingKeySpec(wrappingKeySpec);
        GetParametersForImportResponse response = (GetParametersForImportResponse)this.kmsClient.getAcsResponse((AcsRequest)request);
        return response;
    }

    public CreateKeyResponse createKey() throws Exception {
        CreateKeyRequest request = new CreateKeyRequest();
        request.setOrigin("EXTERNAL");
        return (CreateKeyResponse)this.kmsClient.getAcsResponse((AcsRequest)request);
    }

    public ListSecretsResponse listSecret(String fetchTag, Integer pageNumber, Integer pageSize) throws ClientException {
        ListSecretsRequest request = new ListSecretsRequest();
        request.setFetchTags(fetchTag);
        request.setPageNumber(pageNumber);
        request.setPageSize(pageSize);
        ListSecretsResponse response = (ListSecretsResponse)this.kmsClient.getAcsResponse((AcsRequest)request);
        return response;
    }

    public GetSecretValueResponse getSecretValue(String secretName) throws ClientException {
        GetSecretValueRequest request = new GetSecretValueRequest();
        request.setSecretName(secretName);
        GetSecretValueResponse response = (GetSecretValueResponse)this.kmsClient.getAcsResponse((AcsRequest)request);
        return response;
    }

    public CreateSecretResponse createSecret(String secretName, String versionId, String secretData, String encryptionKeyId, String secretDataType, String description, String tags) throws ClientException {
        CreateSecretRequest request = new CreateSecretRequest();
        request.setSecretName(secretName);
        request.setVersionId(versionId);
        request.setSecretData(secretData);
        request.setEncryptionKeyId(encryptionKeyId);
        request.setSecretDataType(secretDataType);
        request.setDescription(description);
        request.setTags(tags);
        CreateSecretResponse response = (CreateSecretResponse)this.kmsClient.getAcsResponse((AcsRequest)request);
        return response;
    }

    public PutSecretValueResponse updateSecretValue(String versionId, String secretName, String secretData) throws ClientException {
        PutSecretValueRequest request = new PutSecretValueRequest();
        request.setVersionId(versionId);
        request.setSecretName(secretName);
        request.setSecretData(secretData);
        PutSecretValueResponse response = (PutSecretValueResponse)this.kmsClient.getAcsResponse((AcsRequest)request);
        return response;
    }
}

