/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.service.kms;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.kms.model.v20160120.CreateSecretResponse;
import com.aliyuncs.kms.model.v20160120.DecryptResponse;
import com.aliyuncs.kms.model.v20160120.EncryptResponse;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyResponse;
import com.aliyuncs.kms.model.v20160120.GetSecretValueResponse;
import com.aliyuncs.kms.model.v20160120.ListKeysResponse;
import com.aliyuncs.kms.model.v20160120.ListSecretsResponse;
import com.aliyuncs.kms.model.v20160120.PutSecretValueResponse;
import com.xforceplus.finance.dvas.common.service.kms.KmsClient;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KmsUtils {
    private static final Logger log = LoggerFactory.getLogger(KmsUtils.class);
    @Value(value="${aliyun.kms.accessKeyId:}")
    private String accessKeyId;
    @Value(value="${aliyun.kms.accessKeySecret:}")
    private String accessKeySecret;
    @Value(value="${aliyun.kms.regionId:}")
    private String regionId;
    @Value(value="${aliyun.kms.keyId:}")
    private String keyId;
    private KmsClient kmsClient;
    private int maxRetries = 2;

    @PostConstruct
    public KmsClient getKmsClient() {
        this.kmsClient = KmsClient.getClientForPublicEndpoint(this.regionId, this.accessKeyId, this.accessKeySecret);
        return this.kmsClient;
    }

    public String encrypt(String plainText) {
        log.info("[\u52a0\u5bc6]keyId: {}, plainText:{}", (Object)this.keyId, (Object)plainText);
        String cipherBlob = "";
        try {
            EncryptResponse encResponse = this.kmsClient.encrypt(this.keyId, plainText);
            cipherBlob = encResponse.getCiphertextBlob();
            log.info("CiphertextBlob: " + cipherBlob);
        }
        catch (ClientException eResponse) {
            log.warn("[\u52a0\u5bc6\u5f02\u5e38] eResponse:{}", (Throwable)eResponse);
        }
        return cipherBlob;
    }

    public String decrypt(String cipherBlob) {
        String plainText = "";
        for (int i = 0; i < this.maxRetries; ++i) {
            try {
                DecryptResponse decResponse = this.kmsClient.decrypt(cipherBlob);
                plainText = decResponse.getPlaintext();
                log.info("[\u89e3\u5bc6\u5b8c\u6210] plainText:{}, KeyId:{}", (Object)plainText, (Object)decResponse.getKeyId());
                return plainText;
            }
            catch (ClientException eResponse) {
                if (eResponse.getErrCode().contains("Rejected.Throttling")) {
                    try {
                        Thread.sleep(this.getWaitTimeExponential(i + 1));
                    }
                    catch (InterruptedException ignore) {
                        log.warn("[\u4e2d\u65ad\u5f02\u5e38]");
                    }
                }
                log.warn("[\u89e3\u5bc6\u5f02\u5e38] eResponse:{}", (Throwable)eResponse);
                continue;
            }
        }
        return plainText;
    }

    public long getWaitTimeExponential(int retryCount) {
        int initialDelay = 200;
        long waitTime = (long)Math.pow(2.0, retryCount) * (long)initialDelay;
        return waitTime;
    }

    public ListKeysResponse listKey(int pageNumber, int pageSize) {
        ListKeysResponse listKeysResponse = null;
        try {
            listKeysResponse = this.kmsClient.listKey(pageNumber, pageSize);
        }
        catch (ClientException e) {
            log.warn("[\u83b7\u53d6\u5bc6\u94a5\u5217\u8868\u5f02\u5e38]e:{}", (Throwable)e);
        }
        return listKeysResponse;
    }

    public GenerateDataKeyResponse generateDataKey(String keyDesc, int numOfBytes) {
        GenerateDataKeyResponse genDKResponse = null;
        try {
            genDKResponse = this.kmsClient.generateDataKey(this.keyId, keyDesc, numOfBytes);
            log.info("[\u5bc6\u94a5\u79d8\u6587]CiphertextBlob: {}", (Object)genDKResponse.getCiphertextBlob());
            log.info("[\u5bc6\u94a5id] KeyId: {}", (Object)genDKResponse.getKeyId());
            log.info("[\u5bc6\u94a5\u660e\u6587]Plaintext: {}", (Object)genDKResponse.getPlaintext());
        }
        catch (ClientException eResponse) {
            log.warn("[\u751f\u6210\u5bc6\u94a5\u5f02\u5e38] eResponse:{}", (Throwable)eResponse);
        }
        return genDKResponse;
    }

    public ListSecretsResponse getListSecret(String fetchTag, Integer pageNumber, Integer pageSize) {
        ListSecretsResponse listSecretsResponse = null;
        try {
            listSecretsResponse = this.kmsClient.listSecret(fetchTag, pageNumber, pageSize);
        }
        catch (ClientException e) {
            log.warn("[\u83b7\u53d6\u51ed\u636e\u5217\u8868\u5f02\u5e38] e:{}", (Throwable)e);
        }
        return listSecretsResponse;
    }

    public GetSecretValueResponse getSecretValue(String secretName) {
        GetSecretValueResponse secretValue = null;
        try {
            secretValue = this.kmsClient.getSecretValue(secretName);
        }
        catch (ClientException e) {
            log.warn("[\u83b7\u53d6\u51ed\u636e\u503c\u5f02\u5e38]e:{}", (Throwable)e);
        }
        return secretValue;
    }

    public CreateSecretResponse createSecret(String secretName, String versionId, String secretData, String encryptionKeyId, String secretDataType, String description, String tags) {
        CreateSecretResponse secret = null;
        try {
            secret = this.kmsClient.createSecret(secretName, versionId, secretData, encryptionKeyId, secretDataType, description, tags);
        }
        catch (ClientException e) {
            log.warn("[\u521b\u5efa\u51ed\u636e\u5f02\u5e38]e:{}", (Throwable)e);
        }
        return secret;
    }

    public PutSecretValueResponse updateSecretValue(String versionId, String secretName, String secretData) {
        PutSecretValueResponse putSecretValueResponse = null;
        try {
            putSecretValueResponse = this.kmsClient.updateSecretValue(versionId, secretName, secretData);
        }
        catch (ClientException e) {
            log.warn("[\u66f4\u65b0\u51ed\u636e\u7248\u672c\u503c\u5f02\u5e38] e:{}", (Throwable)e);
        }
        return putSecretValueResponse;
    }
}

