/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.utils;

import com.xforceplus.finance.dvas.common.enums.Message;
import com.xforceplus.finance.dvas.common.exception.BusinessCheckException;
import com.xforceplus.finance.dvas.common.utils.SafeDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    public static final String DATE_FORMAT_19 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_10 = "yyyy-MM-dd";
    public static final String DATE_FORMAT_11 = "yyyyMMdd";
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);

    public static Date convertLocalDate(org.joda.time.LocalDate localDate) {
        return localDate.toDateTimeAtStartOfDay(DateTimeZone.getDefault()).toInstant().toDate();
    }

    public static Date toDate(org.joda.time.LocalDate localDate) {
        return localDate == null ? null : localDate.toDate();
    }

    public static Date toDate(DateTime dateTime) {
        return dateTime == null ? null : dateTime.toDate();
    }

    public static Date toDate(String dateTime) {
        SimpleDateFormat dateformat = new SimpleDateFormat(DATE_FORMAT_19);
        try {
            return dateformat.parse(dateTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static Date toDate(String date, String format) {
        SimpleDateFormat dateformat = new SimpleDateFormat(format);
        try {
            return dateformat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static Date curDate() {
        return new Date();
    }

    public static Date addDays(Date sDate, int num) {
        if (sDate == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(sDate);
        c.add(5, num);
        return c.getTime();
    }

    public static Date getDate(Long currentTimeMillis) {
        return new Date(currentTimeMillis);
    }

    public static String getDateStr(Long currentTimeMillis) {
        SimpleDateFormat dateformat = new SimpleDateFormat(DATE_FORMAT_19);
        return dateformat.format(currentTimeMillis);
    }

    public static org.joda.time.LocalDate toLocalDate(Date date) {
        LocalDateTime localDateTime = LocalDateTime.fromDateFields((Date)date);
        return localDateTime.toLocalDate();
    }

    public static String getCurrentDateStr(String format) {
        return new SimpleDateFormat(format).format(System.currentTimeMillis());
    }

    public static String getDateStr(Date date, String format) {
        SimpleDateFormat dateformat = new SimpleDateFormat(format);
        return date == null ? "" : dateformat.format(date);
    }

    public static Date getLocalDate() {
        ZoneId zoneId = ZoneId.systemDefault();
        return Date.from(java.time.LocalDateTime.now().atZone(zoneId).toInstant());
    }

    public static java.time.LocalDateTime getLocalDateTime() {
        return java.time.LocalDateTime.now();
    }

    public static String getTimeStamp() {
        return Long.valueOf(System.currentTimeMillis()).toString();
    }

    public static LocalDate strToLocalDate(String str) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(DATE_FORMAT_10);
        LocalDate date = LocalDate.parse(str, fmt);
        return date;
    }

    public static LocalDate strToLocalDate(String str, String formatPattern) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(formatPattern);
        LocalDate date = LocalDate.parse(str, fmt);
        return date;
    }

    public static java.time.LocalDateTime strToLocalDateyyyyMMdd(String str) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(DATE_FORMAT_11);
        return LocalDate.parse(str, fmt).atStartOfDay();
    }

    public static java.time.LocalDateTime strToLocalDateyyyyMMddHHmmss(String str) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(DATE_FORMAT_19);
        return LocalDate.parse(str, fmt).atStartOfDay();
    }

    public static java.time.LocalDateTime strToLocalDateTime(String str) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(DATE_FORMAT_10);
        LocalDate date = LocalDate.parse(str, fmt);
        java.time.LocalDateTime dateTime = date.atStartOfDay();
        return dateTime;
    }

    public static LocalDate timestampToLocalDate(String timestamp) {
        Long time = Long.valueOf(timestamp);
        LocalDate localDate = Instant.ofEpochMilli(time).atZone(ZoneOffset.ofHours(8)).toLocalDate();
        return localDate;
    }

    public static String getLocalDateStr(java.time.LocalDateTime date, String format) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        String localTimeStr = df.format(date);
        return localTimeStr;
    }

    public static String getLocalDateNow(String format) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        String localTimeStr = df.format(java.time.LocalDateTime.now());
        return localTimeStr;
    }

    public static String changeStrDate(String date) {
        Date d;
        DateFormat dateString = SafeDateFormat.getDateString();
        try {
            d = dateString.parse(date);
        }
        catch (ParseException e) {
            logger.warn("[\u89e3\u6790\u65e5\u671f\u683c\u5f0f\u5f02\u5e38]e:{}", (Throwable)e);
            return null;
        }
        DateFormat dateFormat = SafeDateFormat.get();
        String newDate = dateFormat.format(d);
        return newDate;
    }

    public static Long strDateToTimestamp(String strDate) {
        Date date;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
        try {
            date = format.parse(strDate);
        }
        catch (ParseException e) {
            logger.warn("[\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38]e:{}", (Throwable)e);
            throw new BusinessCheckException(Message.PARAM_CHECK_ERROR);
        }
        return date.getTime();
    }

    public static Boolean isWorkDay(Date date) {
        LocalDate now = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        DayOfWeek dayOfWeek = now.getDayOfWeek();
        if (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

