/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.utils;

import com.xforceplus.finance.dvas.common.accModel.qcc.eCIBranch.OperInfo;
import com.xforceplus.finance.dvas.common.accModel.qcc.eCIChange.ECIChangeResponseData;
import com.xforceplus.finance.dvas.common.accModel.qcc.taxOweNoticeCheckDetail.Oper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateSqlFromEntity {
    private static final Logger log = LoggerFactory.getLogger(GenerateSqlFromEntity.class);
    public static final String segmentation = "====================================================================\n";
    public static final Class[] defClassList = new Class[]{OperInfo.class, Oper.class};

    public static void main(String[] a) {
        Class[] klass = new Class[]{ECIChangeResponseData.class};
        try {
            for (Class aClass : klass) {
                GenerateSqlFromEntity.generateTableSql(aClass, null);
            }
        }
        catch (Exception ex) {
            log.info("\u8f6c\u6362\u5f02\u5e38,{}", (Throwable)ex);
        }
        System.out.println("\u64cd\u4f5c\u7ed3\u675f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String content, String outputPath) {
        File file = new File(outputPath);
        System.out.println("\u6587\u4ef6\u8def\u5f84: " + file.getAbsolutePath());
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter out = null;
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            fos = new FileOutputStream(file, true);
            osw = new OutputStreamWriter(fos);
            out = new BufferedWriter(osw);
            out.write(content);
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                osw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void generateTableSql(Class obj, String tableName) throws Exception {
        ApiModel apiModel = obj.getAnnotation(ApiModel.class);
        if (tableName == null || tableName.equals("")) {
            tableName = obj.getName();
            tableName = tableName.substring(tableName.lastIndexOf(".") + 1);
        }
        tableName = apiModel.value();
        Field[] fields = obj.getDeclaredFields();
        Object param = null;
        Object column = null;
        StringBuilder sb = new StringBuilder();
        sb.append("drop table if exists ").append(tableName).append(";\r\n");
        sb.append("\r\n");
        sb.append("create table ").append(tableName).append("(\r\n");
        GenerateSqlFromEntity.defaultSqlField(sb);
        GenerateSqlFromEntity.genSQLByFileds(fields, sb);
        GenerateSqlFromEntity.defaultIndex(sb);
        GenerateSqlFromEntity.sqlTail(sb, apiModel.description());
        String sql = sb.toString();
        log.info(segmentation);
        System.out.println(sql);
        log.info(segmentation);
    }

    public static void genSQLByFileds(Field[] fields, StringBuilder sb) throws Exception {
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Class<?> param = f.getType();
            if (param == Integer.class) {
                GenerateSqlFromEntity.sqlFiled(f, sb).append(" INTEGER ");
            } else if (param == Date.class) {
                GenerateSqlFromEntity.sqlFiled(f, sb).append(" datetime DEFAULT NULL ");
            } else if (param == String.class) {
                int length = 50;
                GenerateSqlFromEntity.sqlFiled(f, sb).append(" VARCHAR(" + length + ")");
            } else if (Arrays.asList(defClassList).contains(param)) {
                Field[] paramDeclaredFields = param.getDeclaredFields();
                GenerateSqlFromEntity.genSQLByFileds(paramDeclaredFields, sb);
            }
            ApiModelProperty apiModelProperty = f.getAnnotation(ApiModelProperty.class);
            if (apiModelProperty != null) {
                sb.append(" COMMENT '").append(apiModelProperty.value()).append("'");
            }
            sb.append(", ").append("\n");
        }
    }

    public static StringBuilder sqlFiled(Field f, StringBuilder sb) {
        sb.append(GenerateSqlFromEntity.humpToLine(f.getName()));
        return sb;
    }

    public static void sqlTail(StringBuilder stringBuilder, String tableComment) {
        stringBuilder.append("\n) ");
        stringBuilder.append("ENGINE = INNODB DEFAULT  CHARSET = utf8  ROW_FORMAT=COMPACT");
        stringBuilder.append(" COMMENT='" + tableComment + "';");
    }

    public static void defaultIndex(StringBuilder stringBuilder) {
        stringBuilder.append("PRIMARY KEY (`record_id`),").append("\n");
        stringBuilder.append("KEY `IDX_TAXNUM` (`tax_num`) ").append("\n");
    }

    public static void defaultSqlField(StringBuilder stringBuilder) {
        stringBuilder.append("record_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '\u81ea\u589e\u4e3b\u952e',").append("\n");
        stringBuilder.append("company_record_id bigint(20) NOT NULL COMMENT '\u516c\u53f8ID',").append("\n");
        stringBuilder.append("tax_num varchar(50) NOT NULL DEFAULT '' COMMENT '\u7a0e\u53f7',").append("\n");
    }

    public static String humpToLine(String str) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString().toLowerCase();
    }
}

