/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SafeDateFormat {
    public static final ThreadLocal<DateFormat> TL_DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    public static final ThreadLocal<DateFormat> TL_DATE_TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    public static final ThreadLocal<DateFormat> TL_DATE_STRING_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd"));

    public static DateFormat get() {
        return TL_DATE_FORMAT.get();
    }

    public static DateFormat getDateTime() {
        return TL_DATE_TIME_FORMAT.get();
    }

    public static DateFormat getDateString() {
        return TL_DATE_STRING_FORMAT.get();
    }

    public static boolean isLegalDate(int length, String sDate, String format) {
        int legalLen = length;
        if (sDate == null || sDate.length() != legalLen) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            Date date = formatter.parse(sDate);
            return sDate.equals(formatter.format(date));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int compareDate(String date1, String date2) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date dt1 = dateFormat.parse(date1);
        Date dt2 = dateFormat.parse(date2);
        if (dt1.getTime() > dt2.getTime()) {
            return -1;
        }
        if (dt1.getTime() < dt2.getTime()) {
            return 1;
        }
        return 0;
    }
}

