/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.utils;

import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    private static final String SECRET_KEY = "D1213A69DF99470694D17E01E2C0A3D2";
    private static final String DES = "DES";
    private static final String MD5 = "MD5";
    private static final String SHA = "SHA1";

    public static String md5(String source) {
        return SignUtil.encryption(source, MD5);
    }

    public static String sha(String source) {
        return SignUtil.encryption(source, SHA);
    }

    public static String sha(String source, String salt) {
        return SignUtil.encryption(source + salt, SHA);
    }

    private static String encryption(String plainText, String type) {
        String re_md5 = new String();
        try {
            MessageDigest md = MessageDigest.getInstance(type);
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            re_md5 = buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return re_md5;
    }

    private static byte[] encrypt(byte[] src, byte[] key) throws RuntimeException {
        try {
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            SecretKey securekey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance(DES);
            cipher.init(1, (Key)securekey, sr);
            return cipher.doFinal(src);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] decrypt(byte[] src, byte[] key) throws RuntimeException {
        try {
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
            SecretKey securekey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance(DES);
            cipher.init(2, (Key)securekey, sr);
            return cipher.doFinal(src);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final String decrypt(String data, String key) {
        return new String(SignUtil.decrypt(SignUtil.hex2byte(data.getBytes()), key.getBytes()));
    }

    public static final String encrypt(String data, String key) {
        if (data != null) {
            try {
                return SignUtil.byte2hex(SignUtil.encrypt(data.getBytes(), key.getBytes()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    private static byte[] hex2byte(byte[] b) {
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        byte[] b2 = new byte[b.length / 2];
        for (int n = 0; n < b.length; n += 2) {
            String item = new String(b, n, 2);
            b2[n / 2] = (byte)Integer.parseInt(item, 16);
        }
        return b2;
    }

    public static String base64UrlSafeEncode(String content) {
        return Base64Utils.encodeToUrlSafeString((byte[])content.getBytes());
    }

    public static String base64UrlSafeDecode(String content) throws Exception {
        return new String(Base64Utils.decodeFromUrlSafeString((String)content), "UTF-8");
    }

    public static String generateToken(String tenantId, String accountId, String source, String ext, Long loginTimeMills, String url) throws Exception {
        StringBuffer accountInfo = new StringBuffer();
        accountInfo.append(tenantId).append("_");
        accountInfo.append(accountId).append("_");
        accountInfo.append(source).append("_");
        accountInfo.append(ext);
        String md = SignUtil.sha(accountInfo.toString() + ";" + loginTimeMills + ";" + SECRET_KEY);
        String token = SignUtil.base64UrlSafeEncode(accountInfo.toString() + ";" + loginTimeMills + ";" + url + ";" + md);
        return token;
    }
}

