/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.finance.dvas.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SocketClient {
    private static final Logger log = LoggerFactory.getLogger(SocketClient.class);

    public String sendSocketMsg(String ip, int port, String msg) {
        BufferedReader rd = null;
        BufferedWriter wr = null;
        Socket socket = null;
        try {
            String returnStr;
            socket = new Socket();
            socket.connect(new InetSocketAddress(ip, port), 10000);
            wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "GBK"));
            wr.write(msg);
            wr.flush();
            rd = new BufferedReader(new InputStreamReader(socket.getInputStream(), "GBK"));
            String line = null;
            StringBuffer sb = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            String string = returnStr = sb.toString();
            return string;
        }
        catch (SocketTimeoutException e) {
            log.error("[{} Socket\u8c03\u7528\u8d85\u65f6]: Address:{}", (Object)"shBankError", (Object)(ip + ":" + port));
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error("[{} Socket\u8c03\u7528\u5f02\u5e38]: {}", (Object)"shBankError", (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (wr != null) {
                    wr.close();
                }
                if (rd != null) {
                    rd.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

