/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.listener;

import com.xforceplus.xplatalarm.content.ExceptionNotice;
import com.xforceplus.xplatalarm.message.INoticeSendComponent;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationListener;

public class ApplicationFailedEventListener
implements ApplicationListener<ApplicationFailedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationFailedEventListener.class);
    @Value(value="${spring.application.name:}")
    String appName;
    @Autowired
    private Optional<INoticeSendComponent> noticeSendComponent;

    public void onApplicationEvent(ApplicationFailedEvent event) {
        try {
            log.error("\u7cfb\u7edf\u542f\u52a8\u5931\u8d25......", event.getException());
            this.sendAlarm(event.getException());
        }
        catch (Exception e) {
            log.error("\u544a\u8b66\u5f02\u5e38", (Throwable)e);
        }
    }

    private void sendAlarm(Throwable ex) {
        this.noticeSendComponent.ifPresent(e -> {
            ExceptionNotice exceptionNotice = new ExceptionNotice(ex, "com.xforceplus");
            exceptionNotice.setTraceId("application startup failed");
            exceptionNotice.setProject(this.appName);
            e.send(exceptionNotice);
        });
    }
}

