package com.xforceplus.listener;

import com.xforceplus.xplatalarm.content.ExceptionNotice;
import com.xforceplus.xplatalarm.message.INoticeSendComponent;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationListener;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/10/16 22:34
 */
@Slf4j
public class ApplicationFailedEventListener implements ApplicationListener<ApplicationFailedEvent> {

    @Value("${spring.application.name:}")
    String appName;
    @Autowired
    private Optional<INoticeSendComponent> noticeSendComponent;

    public ApplicationFailedEventListener() {
    }

    @Override
    public void onApplicationEvent(final ApplicationFailedEvent event) {
        try {
            log.error("系统启动失败......", event.getException());
            this.sendAlarm(event.getException());
        } catch (final Exception e) {
            log.error("告警异常", e);
        }

    }

    private void sendAlarm(final Throwable ex) {
        noticeSendComponent.ifPresent(e -> {
            final ExceptionNotice exceptionNotice = new ExceptionNotice(ex, "com.xforceplus");
            exceptionNotice.setTraceId("application startup failed");
            exceptionNotice.setProject(appName);
            e.send(exceptionNotice);
        });

    }

}
