package com.xforceplus.listener;

import com.xforceplus.xplatalarm.message.INoticeSendComponent;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/10/16 21:40
 */

@Slf4j
public class ApplicationReadyEventListener implements ApplicationListener<ApplicationReadyEvent> {

    @Value("${spring.application.name:}")
    String appName;
    @Value("${xforce.gen-tool.actuator.enabled:false}")
    private boolean enabled;
    @Value("${server.port:}")
    private String port;
    @Value("${management.endpoints.web.base-path:/actuator}")
    private String basePath;
    @Autowired
    private Optional<INoticeSendComponent> noticeSendComponent;

    public ApplicationReadyEventListener() {
    }

    @Override
    public void onApplicationEvent(final ApplicationReadyEvent event) {
        try {
            this.sendHealthNotice();
        } catch (final Exception e) {
            log.error("ApplicationReadyEvent", e);
        }

    }

    private void sendHealthNotice() {
        if (!enabled) {
            return;
        }
        final RestTemplate restTemplate = new RestTemplate();
        String json;
        final StringBuilder notice = new StringBuilder();

        try {
            json = restTemplate.getForObject(String.format("http://localhost:%s%s%s", this.port, basePath, StringUtils.endsWithIgnoreCase(this.basePath, "/") ? "health" : "/health"), String.class,
                new Object[0]);
            notice.append(String.format("%s[上线]%s", this.appName, json));
        } catch (final HttpServerErrorException httpServerErrorException) {
            json = httpServerErrorException.getResponseBodyAsString();
            notice.append(String.format("%s[异常]%s", this.appName, json));
        } catch (final Exception e) {
            log.error("health异常", e);
            notice.append(String.format("%s[异常]%s", this.appName, e.getMessage()));
        }

        this.noticeSendComponent.ifPresent(component -> component.send(notice.toString()));
    }

}
