/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.listener;

import com.xforceplus.xplatalarm.message.INoticeSendComponent;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

public class ApplicationReadyEventListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationReadyEventListener.class);
    @Value(value="${spring.application.name:}")
    String appName;
    @Value(value="${xforce.gen-tool.actuator.enabled:false}")
    private boolean enabled;
    @Value(value="${server.port:}")
    private String port;
    @Value(value="${management.endpoints.web.base-path:/actuator}")
    private String basePath;
    @Autowired
    private Optional<INoticeSendComponent> noticeSendComponent;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            this.sendHealthNotice();
        }
        catch (Exception e) {
            log.error("ApplicationReadyEvent", (Throwable)e);
        }
    }

    private void sendHealthNotice() {
        if (!this.enabled) {
            return;
        }
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder notice = new StringBuilder();
        try {
            String json = (String)restTemplate.getForObject(String.format("http://localhost:%s%s%s", this.port, this.basePath, StringUtils.endsWithIgnoreCase((String)this.basePath, (String)"/") ? "health" : "/health"), String.class, new Object[0]);
            notice.append(String.format("%s[\u4e0a\u7ebf]%s", this.appName, json));
        }
        catch (HttpServerErrorException httpServerErrorException) {
            String json = httpServerErrorException.getResponseBodyAsString();
            notice.append(String.format("%s[\u5f02\u5e38]%s", this.appName, json));
        }
        catch (Exception e) {
            log.error("health\u5f02\u5e38", (Throwable)e);
            notice.append(String.format("%s[\u5f02\u5e38]%s", this.appName, e.getMessage()));
        }
        this.noticeSendComponent.ifPresent(component -> component.send(notice.toString()));
    }
}

