package com.xforceplus.general.alarm.adapter.driven;

import static java.util.stream.Collectors.toList;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/2/20 11:12
 */
@Slf4j
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class RemoteHttpAdapter {

    private Gson gson;

    public RemoteHttpAdapter(final Gson gson) {
        this.gson = gson;
    }

    private final Log logger = LogFactory.getLog(getClass());

    private final String defaultContentType = "application/json; charset=utf-8";

    public <K> String doPost(final String url, final K jsonParam, final Map<String, String> headers)
        throws ClientProtocolException, IOException {
        final CloseableHttpClient httpclient = HttpClients.createDefault();
        final HttpPost post = new HttpPost(url);
        headers.forEach((x, y) -> post.setHeader(x, y));
        final StringEntity entity;
        CloseableHttpResponse response = null;
        try {
            if (jsonParam != null) {
                final String jsonStr = gson.toJson(jsonParam);
                logger.debug("json:" + jsonStr);
                entity = new StringEntity(jsonStr, Charset.forName("utf-8"));
                entity.setContentType("application/json");
                post.setEntity(entity);
            }
            response = httpclient.execute(post);
            final String respStr = EntityUtils.toString(response.getEntity(), Charset.forName("utf-8"));
            logger.debug(respStr);
            response.close();
            return respStr;
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public <T, K> T post(final String url, final K jsonParam, final Class<T> clazz) {
        return post(url, jsonParam, clazz, null);
    }

    public <T, K> T post(final String url, final K jsonParam, final Class<T> clazz, Map<String, String> header) {
        String json = null;
        header = header == null ? new HashMap<>() : header;
        if (!header.containsKey(HTTP.CONTENT_TYPE)) {
            header.put(HTTP.CONTENT_TYPE, defaultContentType);
        }
        try {
            json = doPost(url, jsonParam, header);
        } catch (final IOException e) {
            logger.error(e);
        }
        final T res = json == null ? null : gson.fromJson(json, clazz);
        return res;
    }

    public <K, T> T post(final String url, final K jsonParam, final TypeToken<T> type) {
        return post(url, jsonParam, type, null);
    }

    public <K, T> T post(final String url, final K jsonParam, final TypeToken<T> type, Map<String, String> header) {
        header = header == null ? new HashMap<>() : header;
        if (!header.containsKey(HTTP.CONTENT_TYPE)) {
            header.put(HTTP.CONTENT_TYPE, defaultContentType);
        }
        String json = null;
        try {
            json = doPost(url, jsonParam, header);
        } catch (final IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        final T res = json == null ? null : gson.fromJson(json, type.getType());
        return res;
    }

    public <T> T doPost(final String url, final Class<T> clazz, final Map<String, String> Param, final Map<String, Object> headers) {
        final CloseableHttpClient httpclient = HttpClients.createDefault();
        final HttpPost post = new HttpPost(url);
        headers.forEach((x, y) -> post.setHeader(x, y.toString()));
        try {
            final List<NameValuePair> list = Param.entrySet().stream()
                .map(x -> new BasicNameValuePair(x.getKey(), x.getValue())).collect(toList());
            post.setEntity(new UrlEncodedFormEntity(list));
            final CloseableHttpResponse response = httpclient.execute(post);
            final String respStr = EntityUtils.toString(response.getEntity(), Charset.forName("UTF-8"));
            final T result = gson.fromJson(respStr, clazz);
            response.close();
            return result;
        } catch (final UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (final ClientProtocolException e) {
            e.printStackTrace();
        } catch (final IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T doPost(final String url, final TypeToken<T> type, final Map<String, String> Param, final Map<String, Object> headers) {
        final CloseableHttpClient httpclient = HttpClients.createDefault();
        final HttpPost post = new HttpPost(url);
        headers.forEach((x, y) -> post.setHeader(x, y.toString()));
        try {
            final List<NameValuePair> list = Param.entrySet().stream()
                .map(x -> new BasicNameValuePair(x.getKey(), x.getValue())).collect(toList());
            post.setEntity(new UrlEncodedFormEntity(list));
            final CloseableHttpResponse response = httpclient.execute(post);
            final String respStr = EntityUtils.toString(response.getEntity(), Charset.forName("UTF-8"));
            final T result = gson.fromJson(respStr, type.getType());
            response.close();
            return result;
        } catch (final UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (final ClientProtocolException e) {
            e.printStackTrace();
        } catch (final IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T doGet(final String uri, final Class<T> clazz) {
        final CloseableHttpClient httpclient = HttpClients.createDefault();
        final HttpGet get = new HttpGet(uri);
        try {
            final CloseableHttpResponse response = httpclient.execute(get);
            final String respStr = EntityUtils.toString(response.getEntity());
            response.close();
            final T result = gson.fromJson(respStr, clazz);
            return result;
        } catch (final IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T doGet(final String url, final TypeToken<T> type, final Map<String, String> param, final Map<String, Object> header) {
        final CloseableHttpClient httpclient = HttpClients.createDefault();
        final String uri = String.format("%s?%s", url, String.join("&", param.entrySet().stream()
            .map(x -> String.format("%s=%s", x.getKey(), x.getValue())).collect(toList())));
        final HttpGet get = new HttpGet(uri);
        try {
            header.forEach((x, y) -> get.addHeader(x, y.toString()));
            final CloseableHttpResponse response = httpclient.execute(get);
            final String respStr = EntityUtils.toString(response.getEntity());
            response.close();
            final T result = gson.fromJson(respStr, type.getType());
            return result;
        } catch (final IOException e) {
            e.printStackTrace();
        }
        return null;
    }


}
