package com.xforceplus.general.alarm.advice;

import com.xforceplus.general.alarm.service.AlarmService;
import java.util.Arrays;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/2/21 15:12
 */
@Aspect
@Component
@Slf4j
@RequiredArgsConstructor
public class ExceptionAlarmAdvice {

    private final AlarmService alarmService;

    @Pointcut("@annotation(com.xforceplus.general.alarm.annotation.AlarmException)")
    public void alarmException() {
    }

    @AfterThrowing(
        value = "alarmException()",
        throwing = "e"
    )
    public void exceptionNotice(final JoinPoint joinPoint, final RuntimeException e) {
        this.handleException(e, joinPoint.getSignature().getName(), joinPoint.getArgs());
    }

    private void handleException(final Throwable exception, final String methodName, final Object[] args) {
        log.error("出现异常：" + methodName + String.join(",", Arrays.stream(args).map((x) ->
            x.toString()
        ).toArray((x$0) -> {
            return new String[x$0];
        })), exception);
        alarmService.alarm("traceId", exception, args);
    }

}
