package com.xforceplus.general.alarm.configuration;

import com.google.gson.Gson;
import com.xforceplus.general.alarm.adapter.driven.RemoteHttpAdapter;
import com.xforceplus.general.alarm.message.controller.AlarmControlHandler;
import com.xforceplus.general.common.ApplicationContextHolder;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/**
 * @author zhuxingsheng@gmail.com
 * @description: 告警服务自动化配置
 * @date 2023/9/8 18:00
 */
@EnableAsync
@EnableConfigurationProperties(value = {AlarmProperties.class})
@ComponentScan("com.xforceplus.general.alarm")
public class AlarmAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public ApplicationContextHolder generalApplicationContextHolder() {
        return new ApplicationContextHolder();
    }

    @Bean
    public RemoteHttpAdapter remoteHttpAdapter(final Gson gson) {
        final RemoteHttpAdapter httpClient = new RemoteHttpAdapter(gson);
        return httpClient;
    }

    @Bean
    public SendMessageInitializer sendMessageInitializer(final AlarmProperties alarmProperties, final AlarmControlHandler alarmControlHandler) {
        return new SendMessageInitializer(alarmProperties, alarmControlHandler);
    }

    @Bean({"generalToolAlarmTaskExecutor"})
    public Executor taskExecutor() {
        final ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(1);
        executor.setMaxPoolSize(1);
        executor.setQueueCapacity(10);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("generalToolAlarmTaskExecutor-");
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        return executor;
    }

}
