package com.xforceplus.general.alarm.configuration;

import com.google.common.collect.Lists;
import java.util.List;
import lombok.Data;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/10/21 23:52
 */
@Data
@ConfigurationProperties(prefix = "xforce.gen-tool.alarm")
public class AlarmProperties {

    public static final String PREFIX = "xforce.gen-tool.alarm";

    @Value("${spring.application.name}")
    private String projectName;

    private List<NotifyProperties> notifies;

    /**
     * 默认告警配置
     */
    private NotifyProperties defaultNotify = new NotifyProperties();


    public NotifyProperties getNotifyProperties(final String notifyId) {
        final NotifyProperties notifyProperties = ListUtils.emptyIfNull(notifies).stream().filter(property -> StringUtils.equals(notifyId, property.getNotifyId()))
            .findAny()
            .orElse(defaultNotify);
        notifyProperties.setProjectName(projectName);
        return notifyProperties;
    }

    public List<NotifyProperties> getAllNotifyProperties() {
        return Lists.asList(defaultNotify, ListUtils.emptyIfNull(notifies).toArray(new NotifyProperties[0]));
    }

}
