package com.xforceplus.general.alarm.configuration;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import lombok.Data;

/**
 * @author zhuxingsheng@gmail.com
 * @description: 异常告警信息配置
 * @date 2024/2/19 15:00
 */
@Data
public class ExceptionAlarmProperties {

    /**
     * 告警信息中，只包含此包下的堆栈信息，没有配置时，包含所有堆栈
     */
    private String includeStackTracePackages = "com.xforceplus";
    private List<String> excludeExceptions = new LinkedList();
    private List<String> excludeExceptionMessages = Lists.newArrayList(new String[]{"Broken pipe"});

}
