package com.xforceplus.general.alarm.configuration;

import java.util.List;
import lombok.Data;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/10/21 23:58
 */
@Data
public class NotifyProperties {

    private String projectName;
    /**
     * 通知唯一标识
     */
    private String notifyId = "default";

    private String tag;

    private boolean enabled;

    /**
     * 告警的关键字，在钉钉里面配置的关键字
     */
    private String keyword;

    /**
     * 发送消息的采集率
     */
    private int sample = 1;

    /**
     * run alarm interval. unit: s
     */
    private Integer intervalSeconds = 5;

    /**
     * 异常信息处理配置
     */
    private ExceptionAlarmProperties exception = new ExceptionAlarmProperties();

    /**
     * 告警发送到哪些平台
     */
    private List<NotifyPlatformProperties> platforms;

}
