package com.xforceplus.general.alarm.configuration;

import com.xforceplus.general.alarm.message.controller.AlarmControlHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.CommandLineRunner;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/2/20 18:27
 */
@RequiredArgsConstructor
public class SendMessageInitializer implements CommandLineRunner {

    private final AlarmProperties alarmProperties;

    private final AlarmControlHandler alarmControlHandler;


    @Override
    public void run(final String... args) throws Exception {
        alarmProperties.getAllNotifyProperties().forEach(p -> alarmControlHandler.initCacheAndLock(p.getNotifyId(), p.getIntervalSeconds()));
    }

}
