package com.xforceplus.general.alarm.configuration.refresh;

import com.xforceplus.general.alarm.message.controller.AlarmControlHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/3/15 16:36
 */
@Component
@RequiredArgsConstructor
public class AlarmPropertyChangeEventListener implements ApplicationListener<AlarmPropertyChangedEvent> {

    private final AlarmControlHandler alarmControlHandler;

    @Override
    public void onApplicationEvent(final AlarmPropertyChangedEvent event) {
        event.getAlarmProperties().getAllNotifyProperties().forEach(p -> alarmControlHandler.initCacheAndLock(p.getNotifyId(), p.getIntervalSeconds()));
    }

}
