package com.xforceplus.general.alarm.configuration.refresh;

import com.xforceplus.general.alarm.configuration.AlarmProperties;
import com.xforceplus.general.apollo.ApolloRefresher;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/3/14 15:33
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class AlarmPropertyChangeRefreshListener extends ApolloRefresher {

    private final AlarmProperties alarmProperties;

    @Override
    public String bindPropertyTarget() {
        return AlarmProperties.PREFIX;
    }

    @Override
    public Class bindableClass() {
        return AlarmProperties.class;
    }

    @Override
    public Object bindableTarget() {
        return alarmProperties;
    }

    @Override
    public ApplicationEvent publishEvent() {
        return new AlarmPropertyChangedEvent(this, alarmProperties);
    }

}
