package com.xforceplus.general.alarm.context;

import com.xforceplus.general.alarm.message.NotifyPlatform;
import com.xforceplus.general.alarm.message.handler.RobotSendMessageHandler;
import com.xforceplus.general.alarm.message.handler.content.MessageContentTemplate;
import com.xforceplus.general.common.ApplicationContextHolder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2023/10/22 22:17
 */
public class AlarmContext {

    public static RobotSendMessageHandler getSender(final NotifyPlatform notifyPlatform) {
        final Map<String, RobotSendMessageHandler> sendMessageHandlerMap = ApplicationContextHolder.getBeansOfType(RobotSendMessageHandler.class);

        return sendMessageHandlerMap.values().stream().filter(s -> notifyPlatform == s.notifyPlatform()).findFirst()
            .orElseThrow(() -> new IllegalArgumentException("notifyPlatform:" + notifyPlatform + " is not supported"));

    }

    public static MessageContentTemplate getMessageContentTemplate(final String notifyId) {
        final Map<String, MessageContentTemplate> sendMessageHandlerMap = ApplicationContextHolder.getBeansOfType(MessageContentTemplate.class);

        return sendMessageHandlerMap.values().stream().filter(s -> StringUtils.equals(notifyId, s.getNotifyId())).findFirst()
            .orElse(ApplicationContextHolder.getBean("plainTextMessageContent", MessageContentTemplate.class))
            ;
    }

}
