package com.xforceplus.general.alarm.message;

import io.vavr.control.Try;
import java.net.InetAddress;
import org.springframework.util.StringUtils;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/3/6 14:43
 */
public class IpUtil {

    public static String getHostname() {
        return Try.of(() -> {
            return InetAddress.getLocalHost();
        }).map((addr) -> {
            return StringUtils.arrayToDelimitedString(new String[]{addr.getHostName(), addr.getHostAddress()}, ":");
        }).getOrNull();
    }

}
