package com.xforceplus.general.alarm.message.handler.content;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.message.IpUtil;
import com.xforceplus.general.alarm.message.NotifyId;
import com.xforceplus.general.alarm.message.handler.ContentType;
import com.xforceplus.general.alarm.message.handler.ding.RobotMessageRequest;
import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.Map;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/3/6 11:47
 */
@RequiredArgsConstructor
@Slf4j
@Component("plainTextMessageContent")
public class PlainTextMessageContent implements MessageContentTemplate {

    @Override
    public String getNotifyId() {
        return NotifyId.DEFAULT_ID;
    }

    @Override
    public RobotMessageRequest.RobotMessageRequestBuilder buildNoticeMessage(final NotifyProperties notifyProperties, final String traceId, final Tuple2<String, Object>... tuple2s) {
        final Map<String, Object> messageContent = Maps.newLinkedHashMap();
        Arrays.stream(tuple2s).forEach((t) -> {
            messageContent.put(t._1(), t._2());
        });
        messageContent.put("appName", notifyProperties.getProjectName());
        messageContent.put("env", System.getProperty("env"));
        messageContent.put("host", IpUtil.getHostname());
        messageContent.put("traceId", traceId);
        messageContent.put("tag", notifyProperties.getTag());
        final String message = Joiner.on("\r\n").withKeyValueSeparator(": ").join(messageContent);
        final String text = notifyProperties.getKeyword() + "\r\n" + message;

        return RobotMessageRequest.builder()
            .msgtype(ContentType.TEXT)
            .text(text);
    }

}
