package com.xforceplus.general.alarm.message.handler.content;

import static com.xforceplus.general.alarm.message.handler.content.AlarmConstants.HEALTH_INFO;

import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.message.IpUtil;
import com.xforceplus.general.alarm.message.NotifyId;
import com.xforceplus.general.alarm.message.Singleton;
import com.xforceplus.general.alarm.message.handler.ContentType;
import com.xforceplus.general.alarm.message.handler.ding.RobotMessageRequest;
import io.vavr.Tuple2;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/3/6 13:02
 */

@RequiredArgsConstructor
@Slf4j
@Component("startupMessageContent")
public class StartupMessageContent implements MessageContentTemplate {

    @Override
    public String getNotifyId() {
        return NotifyId.STARTUP;
    }

    @Override
    public RobotMessageRequest.RobotMessageRequestBuilder buildNoticeMessage(final NotifyProperties notifyProperties, final String traceId, final Tuple2<String, Object>... tuple2s) {
        final String dingAlarmTxtKey = "message/ding-startup.txt";
        final String alarmContentTxt = Singleton.get(dingAlarmTxtKey, () -> readUtf8String(dingAlarmTxtKey));

        final String text = String.format(
            alarmContentTxt,
            System.getProperty("env"),

            notifyProperties.getProjectName(),
            IpUtil.getHostname(),
            //
            getContent(HEALTH_INFO, tuple2s),

            LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))

        );

        return RobotMessageRequest.builder()
            .msgtype(ContentType.MARKDOWN)
            .title("服务上线：" + notifyProperties.getProjectName())
            .text(text);
    }

    private Object getContent(final String tupleKey, final Tuple2<String, Object>... tuple2s) {
        return Arrays.stream(tuple2s).filter((t) ->
            StringUtils.equals(t._1(), tupleKey)
        ).findFirst().map(Tuple2::_2).orElse(StringUtils.EMPTY);
    }

    @SneakyThrows
    private String readUtf8String(final String path) {
        final int endFlagCode = -1;
        final String resultReadStr;
        final ClassPathResource classPathResource = new ClassPathResource(path);
        try (
            final InputStream inputStream = classPathResource.getInputStream();
            final BufferedInputStream bis = new BufferedInputStream(inputStream);
            final ByteArrayOutputStream buf = new ByteArrayOutputStream()) {
            int result = bis.read();
            while (result != endFlagCode) {
                buf.write((byte) result);
                result = bis.read();
            }
            resultReadStr = buf.toString("UTF-8");
        }
        return resultReadStr;
    }

}
