package com.xforceplus.general.alarm.message.handler.xforce;

import com.google.common.base.Splitter;
import com.xforceplus.general.alarm.adapter.driven.RemoteHttpAdapter;
import com.xforceplus.general.alarm.configuration.NotifyPlatformProperties;
import com.xforceplus.general.alarm.message.NotifyPlatform;
import com.xforceplus.general.alarm.message.handler.ContentType;
import com.xforceplus.general.alarm.message.handler.RobotSendMessageHandler;
import com.xforceplus.general.alarm.message.handler.ding.RobotMessageRequest;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/3/5 14:54
 */
@RequiredArgsConstructor
@Slf4j
@Component("xforceSendMessageHandler")
public class XforceSendMessageHandler implements RobotSendMessageHandler {


    private final RemoteHttpAdapter remoteHttpAdapter;

    @Override
    public NotifyPlatform notifyPlatform() {
        return NotifyPlatform.XFORCE;
    }

    @Override
    public void execute(final RobotMessageRequest robotMessageRequest) {
        final NotifyPlatformProperties notifyConfig = robotMessageRequest.getPlatformProperties();
        String serverUrl = notifyConfig.getSecretKey();
        final String secret = notifyConfig.getSecret();
        if (StringUtils.isNotBlank(secret)) {
            final long timestamp = System.currentTimeMillis();
            final String stringToSign = timestamp + "\n" + secret;
            try {
                final Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
                final byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
                final String sign = URLEncoder.encode(new String(Base64.encodeBase64(signData)), StandardCharsets.UTF_8.name());
                serverUrl = serverUrl + "&timestamp=" + timestamp + "&sign=" + sign;
            } catch (final Exception ex) {
                log.error("Failed to sign the message sent by nailing.", ex);
            }
        }
        final String text = robotMessageRequest.getText();
        final HashMap<String, Object> at = new HashMap<>();
        final List<String> atMobiles = Optional.ofNullable(notifyConfig.getReceives()).map(r -> Splitter.on(",").splitToList(r)).orElse(Collections.EMPTY_LIST);
        at.put("atMobiles", atMobiles);
        at.put("isAtAll", false);

        final HashMap<String, Object> textJson = new HashMap<>();
        textJson.put("at", at);
        if (Optional.ofNullable(robotMessageRequest.getMsgtype()).orElse(ContentType.TEXT) == ContentType.TEXT) {
            textJson.put("msgtype", ContentType.TEXT.getContentType());
            final HashMap<String, Object> content = new HashMap<>();
            content.put("content", text);
            textJson.put("text", content);
        } else {
            textJson.put("msgtype", ContentType.MARKDOWN.getContentType());
            final HashMap<String, Object> markdown = new HashMap<>();
            markdown.put("title", robotMessageRequest.getTitle());
            markdown.put("text", text);
            textJson.put("markdown", markdown);
        }

        try {
            final String response = remoteHttpAdapter.post(serverUrl, textJson, String.class);
            if (log.isDebugEnabled()) {
                log.debug("xforce  send message, response : {}", response);
            }
        } catch (final Exception ex) {
            log.error("Ding failed to send message.", ex);
        }
    }

}
