package com.xforceplus.general.alarm.service;

import static com.xforceplus.general.alarm.message.handler.content.AlarmConstants.ALARM_TIMES;

import com.google.common.collect.Lists;
import com.xforceplus.general.alarm.configuration.AlarmProperties;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.message.NotifyId;
import com.xforceplus.general.alarm.message.controller.AlarmControlHandler;
import com.xforceplus.general.alarm.message.handler.ding.ExceptionAlarmContent;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.List;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author zhuxingsheng@gmail.com
 * @description: alarm使用入口
 * @date 2023/9/5 10:42
 */
@RequiredArgsConstructor
@Slf4j
@Service
public class AlarmService {

    private final AlarmProperties alarmProperties;

    private final AlarmControlHandler alarmControlHandler;

    private final SendMessageService sendMessageService;

    /**
     * @param traceId
     * @param error
     * @param args    参数名和参数值的键值对
     */
    public void alarm(final String traceId, final Throwable error, final Object... args) {
        try {
            final NotifyProperties notifyProperties = alarmProperties.getNotifyProperties(NotifyId.EXCEPTION);
            final ExceptionAlarmContent exceptionAlarmContent = new ExceptionAlarmContent(notifyProperties, traceId, error, notifyProperties.getException().getIncludeStackTracePackages(), args);
            final Tuple2<Boolean, Integer> sendAlarm = alarmControlHandler.isSendAlarm(exceptionAlarmContent, notifyProperties);
            if (!sendAlarm._1) {
                return;
            }
            exceptionAlarmContent.setTimes(sendAlarm._2);
            sendMessageService.alarm(notifyProperties, traceId, exceptionAlarmContent);
        } catch (final Exception exception) {
            log.error("general tool alarm error", exception);
        }
    }

    /**
     * @param notifyId  通知唯一标识，与配置文件对应
     * @param notifyKey 通知内容key，由使用方生成，通过这个key控制消息发送规则
     * @param tuple2s   通知内容
     */
    public void sendNotice(final String notifyId, final String notifyKey, final String traceId, final Tuple2<String, Object>... tuple2s) {
        _sendNotice(notifyId, notifyKey, traceId, tuple2s);
    }

    /**
     * @param notifyId  通知唯一标识，与配置文件对应
     * @param notifyKey 通知内容key，由使用方生成，通过这个key控制消息发送规则
     * @param tuple2s   通知内容
     */
    private void _sendNotice(final String notifyId, final String notifyKey, final String traceId, final Tuple2<String, Object>... tuple2s) {
        try {
            final NotifyProperties notifyProperties = alarmProperties.getNotifyProperties(notifyId);
            final Tuple2<Boolean, Integer> sendAlarm = alarmControlHandler.isSendAlarm(notifyKey, notifyProperties);
            if (!sendAlarm._1) {
                log.info("Notify is under controller not send,request notifyId:{},found notifyId:{},notifyKey:{}", notifyId, notifyProperties.getNotifyId(), notifyKey);
                return;
            }
            final List<Tuple2<String, Object>> list = Lists.newArrayList(tuple2s);
            list.add(Tuple.of(ALARM_TIMES, sendAlarm._2));
            sendMessageService.sendNotice(notifyProperties, traceId, list.toArray(new Tuple2[0]));
        } catch (final Exception e) {
            log.error("general tool notice error", e);
        }
    }

}
