/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.adapter.driven;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHttpAdapter {
    private static final Logger log = LoggerFactory.getLogger(RemoteHttpAdapter.class);
    private Gson gson;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String defaultContentType = "application/json; charset=utf-8";

    public RemoteHttpAdapter(Gson gson) {
        this.gson = gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> String doPost(String url, K jsonParam, Map<String, String> headers) throws ClientProtocolException, IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        headers.forEach((x, y) -> post.setHeader(x, y));
        try (CloseableHttpResponse response = null;){
            if (jsonParam != null) {
                String jsonStr = this.gson.toJson(jsonParam);
                this.logger.debug((Object)("json:" + jsonStr));
                StringEntity entity = new StringEntity(jsonStr, Charset.forName("utf-8"));
                entity.setContentType("application/json");
                post.setEntity((HttpEntity)entity);
            }
            response = httpclient.execute((HttpUriRequest)post);
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("utf-8"));
            this.logger.debug((Object)respStr);
            response.close();
            String string = respStr;
            return string;
        }
    }

    public <T, K> T post(String url, K jsonParam, Class<T> clazz) {
        return this.post(url, jsonParam, clazz, null);
    }

    public <T, K> T post(String url, K jsonParam, Class<T> clazz, Map<String, String> header) {
        String json = null;
        HashMap<String, String> hashMap = header = header == null ? new HashMap<String, String>() : header;
        if (!header.containsKey("Content-Type")) {
            header.put("Content-Type", "application/json; charset=utf-8");
        }
        try {
            json = this.doPost(url, jsonParam, header);
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        Object res = json == null ? null : this.gson.fromJson(json, clazz);
        return (T)res;
    }

    public <K, T> T post(String url, K jsonParam, TypeToken<T> type) {
        return this.post(url, jsonParam, type, null);
    }

    public <K, T> T post(String url, K jsonParam, TypeToken<T> type, Map<String, String> header) {
        HashMap<String, String> hashMap = header = header == null ? new HashMap<String, String>() : header;
        if (!header.containsKey("Content-Type")) {
            header.put("Content-Type", "application/json; charset=utf-8");
        }
        String json = null;
        try {
            json = this.doPost(url, jsonParam, header);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object res = json == null ? null : this.gson.fromJson(json, type.getType());
        return (T)res;
    }

    public <T> T doPost(String url, Class<T> clazz, Map<String, String> Param, Map<String, Object> headers) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        headers.forEach((x, y) -> post.setHeader(x, y.toString()));
        try {
            List list = Param.entrySet().stream().map(x -> new BasicNameValuePair((String)x.getKey(), (String)x.getValue())).collect(Collectors.toList());
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
            Object result = this.gson.fromJson(respStr, clazz);
            response.close();
            return (T)result;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T doPost(String url, TypeToken<T> type, Map<String, String> Param, Map<String, Object> headers) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        headers.forEach((x, y) -> post.setHeader(x, y.toString()));
        try {
            List list = Param.entrySet().stream().map(x -> new BasicNameValuePair((String)x.getKey(), (String)x.getValue())).collect(Collectors.toList());
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
            Object result = this.gson.fromJson(respStr, type.getType());
            response.close();
            return (T)result;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> T doGet(String uri, Class<T> clazz) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet get = new HttpGet(uri);
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity());
            response.close();
            Object result = this.gson.fromJson(respStr, clazz);
            return (T)result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T doGet(String url, TypeToken<T> type, Map<String, String> param, Map<String, Object> header) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String uri = String.format("%s?%s", url, String.join((CharSequence)"&", param.entrySet().stream().map(x -> String.format("%s=%s", x.getKey(), x.getValue())).collect(Collectors.toList())));
        HttpGet get = new HttpGet(uri);
        try {
            header.forEach((x, y) -> get.addHeader(x, y.toString()));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity());
            response.close();
            Object result = this.gson.fromJson(respStr, type.getType());
            return (T)result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private RemoteHttpAdapter() {
    }
}

