/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.configuration;

import com.google.gson.Gson;
import com.xforceplus.general.alarm.adapter.driven.RemoteHttpAdapter;
import com.xforceplus.general.alarm.configuration.AlarmProperties;
import com.xforceplus.general.alarm.configuration.SendMessageInitializer;
import com.xforceplus.general.alarm.message.controller.AlarmControlHandler;
import com.xforceplus.general.common.ApplicationContextHolder;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@EnableConfigurationProperties(value={AlarmProperties.class})
@ComponentScan(value={"com.xforceplus.general.alarm"})
public class AlarmAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ApplicationContextHolder generalApplicationContextHolder() {
        return new ApplicationContextHolder();
    }

    @Bean
    public RemoteHttpAdapter remoteHttpAdapter(Gson gson) {
        RemoteHttpAdapter httpClient = new RemoteHttpAdapter(gson);
        return httpClient;
    }

    @Bean
    public SendMessageInitializer sendMessageInitializer(AlarmProperties alarmProperties, AlarmControlHandler alarmControlHandler) {
        return new SendMessageInitializer(alarmProperties, alarmControlHandler);
    }

    @Bean(value={"generalToolAlarmTaskExecutor"})
    public Executor taskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(1);
        executor.setMaxPoolSize(1);
        executor.setQueueCapacity(10);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("generalToolAlarmTaskExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
        return executor;
    }
}

