/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.message.controller;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.message.handler.ding.ExceptionAlarmContent;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AlarmControlHandler {
    private final Map<String, ReentrantLock> alarmControllerLock = new HashMap<String, ReentrantLock>();
    private final Map<String, Cache<String, Integer>> alarmControlCacheMap = new ConcurrentHashMap<String, Cache<String, Integer>>();

    public Tuple2<Boolean, Integer> isSendAlarm(String notifyKey, NotifyProperties notifyProperties) {
        if (notifyProperties.isEnabled()) {
            return this.isSendAlarm(notifyProperties.getNotifyId(), notifyKey, notifyProperties);
        }
        return Tuple.of((Object)false, (Object)0);
    }

    public Tuple2<Boolean, Integer> isSendAlarm(ExceptionAlarmContent exceptionAlarmContent, NotifyProperties notifyProperties) {
        if (notifyProperties.isEnabled() && this.isAlarm(exceptionAlarmContent.getException(), notifyProperties)) {
            return this.isSendAlarm(notifyProperties.getNotifyId(), exceptionAlarmContent.getUid(), notifyProperties);
        }
        return Tuple.of((Object)false, (Object)0);
    }

    private boolean isAlarm(Throwable exception, NotifyProperties notifyProperties) {
        if (ListUtils.emptyIfNull(notifyProperties.getException().getExcludeExceptions()).stream().anyMatch(p -> StringUtils.equalsIgnoreCase((CharSequence)exception.getClass().getName(), (CharSequence)p))) {
            return false;
        }
        return !ListUtils.emptyIfNull(notifyProperties.getException().getExcludeExceptionMessages()).stream().anyMatch(p -> StringUtils.equalsIgnoreCase((CharSequence)exception.getMessage(), (CharSequence)p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple2<Boolean, Integer> isSendAlarm(String notifyId, String notifyKey, NotifyProperties notifyProperties) {
        Cache<String, Integer> cache = this.alarmControlCacheMap.get(notifyId);
        if (cache == null) {
            return Tuple.of((Object)false, (Object)0);
        }
        Integer count = (Integer)cache.getIfPresent((Object)notifyKey);
        if (count == null) {
            ReentrantLock lock = this.alarmControllerLock.get(notifyId);
            lock.lock();
            try {
                count = (Integer)cache.getIfPresent((Object)notifyKey);
                if (count == null) {
                    count = 1;
                    cache.put((Object)notifyKey, (Object)count);
                    Tuple2 tuple2 = Tuple.of((Object)true, (Object)count);
                    return tuple2;
                }
                Tuple2<Boolean, Integer> tuple2 = AlarmControlHandler.isSendAlarm(notifyKey, notifyProperties, cache);
                return tuple2;
            }
            finally {
                lock.unlock();
            }
        }
        ReentrantLock lock = this.alarmControllerLock.get(notifyId);
        lock.lock();
        try {
            Tuple2<Boolean, Integer> tuple2 = AlarmControlHandler.isSendAlarm(notifyKey, notifyProperties, cache);
            return tuple2;
        }
        finally {
            lock.unlock();
        }
    }

    private static Tuple2<Boolean, Integer> isSendAlarm(String notifyKey, NotifyProperties notifyProperties, Cache<String, Integer> cache) {
        Integer count = (Integer)cache.getIfPresent((Object)notifyKey);
        count = count + 1;
        cache.put((Object)notifyKey, (Object)count);
        if (notifyProperties.getSample() != 0 & count % notifyProperties.getSample() == 0) {
            return Tuple.of((Object)true, (Object)count);
        }
        return Tuple.of((Object)false, (Object)count);
    }

    public void initCacheAndLock(String notifyId, Integer intervalSeconds) {
        String cacheKey = notifyId;
        Cache cache = Caffeine.newBuilder().expireAfterWrite((long)intervalSeconds.intValue(), TimeUnit.SECONDS).build();
        this.alarmControlCacheMap.put(cacheKey, (Cache<String, Integer>)cache);
        ReentrantLock reentrantLock = new ReentrantLock();
        this.alarmControllerLock.put(cacheKey, reentrantLock);
    }
}

