/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.message.handler.content;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.message.IpUtil;
import com.xforceplus.general.alarm.message.handler.ContentType;
import com.xforceplus.general.alarm.message.handler.content.MessageContentTemplate;
import com.xforceplus.general.alarm.message.handler.ding.RobotMessageRequest;
import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="plainTextMessageContent")
public class PlainTextMessageContent
implements MessageContentTemplate {
    private static final Logger log = LoggerFactory.getLogger(PlainTextMessageContent.class);

    @Override
    public String getNotifyId() {
        return "default";
    }

    @Override
    public RobotMessageRequest.RobotMessageRequestBuilder buildNoticeMessage(NotifyProperties notifyProperties, String traceId, Tuple2<String, Object> ... tuple2s) {
        LinkedHashMap messageContent = Maps.newLinkedHashMap();
        Arrays.stream(tuple2s).forEach(t -> messageContent.put(t._1(), t._2()));
        messageContent.put("appName", notifyProperties.getProjectName());
        messageContent.put("env", System.getProperty("env"));
        messageContent.put("host", IpUtil.getHostname());
        messageContent.put("traceId", traceId);
        messageContent.put("tag", notifyProperties.getTag());
        String message = Joiner.on((String)"\r\n").withKeyValueSeparator(": ").join((Map)messageContent);
        String text = notifyProperties.getKeyword() + "\r\n" + message;
        return RobotMessageRequest.builder().msgtype(ContentType.TEXT).text(text);
    }
}

