/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.service;

import com.google.common.collect.Lists;
import com.xforceplus.general.alarm.configuration.AlarmProperties;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.message.controller.AlarmControlHandler;
import com.xforceplus.general.alarm.message.handler.ding.ExceptionAlarmContent;
import com.xforceplus.general.alarm.service.SendMessageService;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlarmService {
    private static final Logger log = LoggerFactory.getLogger(AlarmService.class);
    private final AlarmProperties alarmProperties;
    private final AlarmControlHandler alarmControlHandler;
    private final SendMessageService sendMessageService;

    public void alarm(String traceId, Throwable error, Object ... args) {
        try {
            NotifyProperties notifyProperties = this.alarmProperties.getNotifyProperties("exception-notify-id");
            ExceptionAlarmContent exceptionAlarmContent = new ExceptionAlarmContent(notifyProperties, traceId, error, notifyProperties.getException().getIncludeStackTracePackages(), args);
            Tuple2<Boolean, Integer> sendAlarm = this.alarmControlHandler.isSendAlarm(exceptionAlarmContent, notifyProperties);
            if (!((Boolean)sendAlarm._1).booleanValue()) {
                return;
            }
            exceptionAlarmContent.setTimes((Integer)sendAlarm._2);
            this.sendMessageService.alarm(notifyProperties, traceId, exceptionAlarmContent);
        }
        catch (Exception exception) {
            log.error("general tool alarm error", (Throwable)exception);
        }
    }

    public void sendNotice(String notifyId, String notifyKey, String traceId, Tuple2<String, Object> ... tuple2s) {
        this._sendNotice(notifyId, notifyKey, traceId, tuple2s);
    }

    private void _sendNotice(String notifyId, String notifyKey, String traceId, Tuple2<String, Object> ... tuple2s) {
        try {
            NotifyProperties notifyProperties = this.alarmProperties.getNotifyProperties(notifyId);
            Tuple2<Boolean, Integer> sendAlarm = this.alarmControlHandler.isSendAlarm(notifyKey, notifyProperties);
            if (!((Boolean)sendAlarm._1).booleanValue()) {
                log.info("Notify is under controller not send,request notifyId:{},found notifyId:{},notifyKey:{}", new Object[]{notifyId, notifyProperties.getNotifyId(), notifyKey});
                return;
            }
            ArrayList list = Lists.newArrayList((Object[])tuple2s);
            list.add(Tuple.of((Object)"times", (Object)sendAlarm._2));
            this.sendMessageService.sendNotice(notifyProperties, traceId, list.toArray(new Tuple2[0]));
        }
        catch (Exception e) {
            log.error("general tool notice error", (Throwable)e);
        }
    }

    public AlarmService(AlarmProperties alarmProperties, AlarmControlHandler alarmControlHandler, SendMessageService sendMessageService) {
        this.alarmProperties = alarmProperties;
        this.alarmControlHandler = alarmControlHandler;
        this.sendMessageService = sendMessageService;
    }
}

