/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.advice;

import com.xforceplus.general.alarm.service.AlarmService;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExceptionAlarmAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAlarmAdvice.class);
    private final AlarmService alarmService;

    @Pointcut(value="@annotation(com.xforceplus.general.alarm.annotation.AlarmException)")
    public void alarmException() {
    }

    @AfterThrowing(value="alarmException()", throwing="e")
    public void exceptionNotice(JoinPoint joinPoint, RuntimeException e) {
        this.handleException(e, joinPoint.getSignature().getName(), joinPoint.getArgs());
    }

    private void handleException(Throwable exception, String methodName, Object[] args) {
        log.error("\u51fa\u73b0\u5f02\u5e38\uff1a" + methodName + String.join((CharSequence)",", (CharSequence[])Arrays.stream(args).map(x -> x.toString()).toArray(String[]::new)), exception);
        this.alarmService.alarm("traceId", exception, args);
    }

    public ExceptionAlarmAdvice(AlarmService alarmService) {
        this.alarmService = alarmService;
    }
}

