/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.configuration;

import com.google.common.collect.Lists;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="xforce.gen-tool.alarm")
public class AlarmProperties {
    public static final String PREFIX = "xforce.gen-tool.alarm";
    @Value(value="${spring.application.name}")
    private String projectName;
    private List<NotifyProperties> notifies;
    private NotifyProperties defaultNotify = new NotifyProperties();

    public NotifyProperties getNotifyProperties(String notifyId) {
        NotifyProperties notifyProperties = ListUtils.emptyIfNull(this.notifies).stream().filter(property -> StringUtils.equals((CharSequence)notifyId, (CharSequence)property.getNotifyId())).findAny().orElse(this.defaultNotify);
        notifyProperties.setProjectName(this.projectName);
        return notifyProperties;
    }

    public List<NotifyProperties> getAllNotifyProperties() {
        return Lists.asList((Object)this.defaultNotify, (Object[])ListUtils.emptyIfNull(this.notifies).toArray(new NotifyProperties[0]));
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<NotifyProperties> getNotifies() {
        return this.notifies;
    }

    public NotifyProperties getDefaultNotify() {
        return this.defaultNotify;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setNotifies(List<NotifyProperties> notifies) {
        this.notifies = notifies;
    }

    public void setDefaultNotify(NotifyProperties defaultNotify) {
        this.defaultNotify = defaultNotify;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmProperties)) {
            return false;
        }
        AlarmProperties other = (AlarmProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        List<NotifyProperties> this$notifies = this.getNotifies();
        List<NotifyProperties> other$notifies = other.getNotifies();
        if (this$notifies == null ? other$notifies != null : !((Object)this$notifies).equals(other$notifies)) {
            return false;
        }
        NotifyProperties this$defaultNotify = this.getDefaultNotify();
        NotifyProperties other$defaultNotify = other.getDefaultNotify();
        return !(this$defaultNotify == null ? other$defaultNotify != null : !((Object)this$defaultNotify).equals(other$defaultNotify));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        List<NotifyProperties> $notifies = this.getNotifies();
        result = result * 59 + ($notifies == null ? 43 : ((Object)$notifies).hashCode());
        NotifyProperties $defaultNotify = this.getDefaultNotify();
        result = result * 59 + ($defaultNotify == null ? 43 : ((Object)$defaultNotify).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmProperties(projectName=" + this.getProjectName() + ", notifies=" + this.getNotifies() + ", defaultNotify=" + this.getDefaultNotify() + ")";
    }
}

