/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.message.handler;

import com.xforceplus.general.alarm.base.annotation.AsyncAlarm;
import com.xforceplus.general.alarm.configuration.NotifyPlatformProperties;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.context.AlarmContext;
import com.xforceplus.general.alarm.message.NotifyPlatform;
import com.xforceplus.general.alarm.message.handler.ding.ExceptionAlarmContent;
import com.xforceplus.general.alarm.message.handler.ding.RobotMessageRequest;
import com.xforceplus.general.alarm.service.SendMessageService;
import io.vavr.Tuple2;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RobotSendMessageService
implements SendMessageService {
    @Override
    @AsyncAlarm
    public void sendNotice(NotifyProperties notifyProperties, String traceId, Tuple2<String, Object> ... tuple2s) {
        notifyProperties.getPlatforms().forEach(p -> EnumUtils.getEnumList(NotifyPlatform.class).stream().filter(n -> StringUtils.equalsAnyIgnoreCase((CharSequence)n.name(), (CharSequence[])new CharSequence[]{p.getPlatform()})).findFirst().ifPresent(platform -> AlarmContext.getSender(platform).execute(AlarmContext.getMessageContentTemplate(notifyProperties.getNotifyId()).buildNoticeMessage(notifyProperties, traceId, tuple2s).platformProperties((NotifyPlatformProperties)p).build())));
    }

    @Override
    @AsyncAlarm
    public void alarm(NotifyProperties notifyProperties, String traceId, ExceptionAlarmContent exceptionAlarmContent) {
        notifyProperties.getPlatforms().forEach(p -> EnumUtils.getEnumList(NotifyPlatform.class).stream().filter(n -> StringUtils.equalsAnyIgnoreCase((CharSequence)n.name(), (CharSequence[])new CharSequence[]{p.getPlatform()})).findFirst().ifPresent(platform -> AlarmContext.getSender(platform).execute(RobotMessageRequest.builder().text(exceptionAlarmContent.createText()).platformProperties((NotifyPlatformProperties)p).build())));
    }
}

