/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.message.handler.content;

import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.message.IpUtil;
import com.xforceplus.general.alarm.message.Singleton;
import com.xforceplus.general.alarm.message.handler.ContentType;
import com.xforceplus.general.alarm.message.handler.content.MessageContentTemplate;
import com.xforceplus.general.alarm.message.handler.ding.RobotMessageRequest;
import io.vavr.Tuple2;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component(value="executorMessageContent")
public class ExecutorMessageContent
implements MessageContentTemplate {
    private static final Logger log = LoggerFactory.getLogger(ExecutorMessageContent.class);

    @Override
    public String getNotifyId() {
        return "executor-notify-id";
    }

    @Override
    public RobotMessageRequest.RobotMessageRequestBuilder buildNoticeMessage(NotifyProperties notifyProperties, String traceId, Tuple2<String, Object> ... tuple2s) {
        String dingAlarmTxtKey = "message/ding-executor.txt";
        String alarmContentTxt = Singleton.get("message/ding-executor.txt", () -> this.readUtf8String("message/ding-executor.txt"));
        String text = String.format(alarmContentTxt, System.getProperty("env"), this.getContent("name", tuple2s), notifyProperties.getProjectName(), IpUtil.getHostname(), this.getContent("NotifyType", tuple2s), this.getContent("alarmThreshold", tuple2s) + "%", this.getContent("alarmCurrentThreshold", tuple2s) + "%", this.getContent("PoolSize", tuple2s), this.getContent("CorePoolSize", tuple2s), this.getContent("MaximumPoolSize", tuple2s), this.getContent("ActiveCount", tuple2s), this.getContent("LargestPoolSize", tuple2s), this.getContent("TaskCount", tuple2s), this.getContent("CompletedTaskCount", tuple2s), this.getContent("QueueType", tuple2s), this.getContent("QueueCapacity", tuple2s), this.getContent("QueueSize", tuple2s), this.getContent("remainingCapacity", tuple2s), this.getContent("RejectedExecutionHandler", tuple2s), this.getContent("rejectTaskCount", tuple2s), notifyProperties.getIntervalSeconds(), this.getContent("times", tuple2s), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return RobotMessageRequest.builder().msgtype(ContentType.MARKDOWN).title("\u7ebf\u7a0b\u6c60\u8fd0\u884c\u544a\u8b66").text(text);
    }

    private Object getContent(String tupleKey, Tuple2<String, Object> ... tuple2s) {
        return Arrays.stream(tuple2s).filter(t -> StringUtils.equals((CharSequence)((CharSequence)t._1()), (CharSequence)tupleKey)).findFirst().map(Tuple2::_2).orElse("");
    }

    private String readUtf8String(String path) {
        String resultReadStr;
        int endFlagCode = -1;
        ClassPathResource classPathResource = new ClassPathResource(path);
        try (InputStream inputStream = classPathResource.getInputStream();
             BufferedInputStream bis = new BufferedInputStream(inputStream);
             ByteArrayOutputStream buf = new ByteArrayOutputStream();){
            int result = bis.read();
            while (result != -1) {
                buf.write((byte)result);
                result = bis.read();
            }
            resultReadStr = buf.toString("UTF-8");
        }
        return resultReadStr;
    }
}

