/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.message.handler.content;

import com.google.common.base.Joiner;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import com.xforceplus.general.alarm.message.IpUtil;
import com.xforceplus.general.alarm.message.Singleton;
import com.xforceplus.general.alarm.message.handler.ContentType;
import com.xforceplus.general.alarm.message.handler.content.MessageContentTemplate;
import com.xforceplus.general.alarm.message.handler.ding.RobotMessageRequest;
import io.vavr.Tuple2;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component(value="startupMessageContent")
public class StartupMessageContent
implements MessageContentTemplate {
    private static final Logger log = LoggerFactory.getLogger(StartupMessageContent.class);

    @Override
    public String getNotifyId() {
        return "startup-notify-id";
    }

    @Override
    public RobotMessageRequest.RobotMessageRequestBuilder buildNoticeMessage(NotifyProperties notifyProperties, String traceId, Tuple2<String, Object> ... tuple2s) {
        String dingAlarmTxtKey = "message/ding-startup.txt";
        String alarmContentTxt = Singleton.get("message/ding-startup.txt", () -> this.readUtf8String("message/ding-startup.txt"));
        String text = String.format(alarmContentTxt, Joiner.on((String)"-").join((Object)System.getProperty("apollo.cluster"), (Object)System.getProperty("env"), new Object[0]), notifyProperties.getProjectName(), IpUtil.getHostname(), this.getContent("health", tuple2s), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return RobotMessageRequest.builder().msgtype(ContentType.MARKDOWN).title("\u670d\u52a1\u4e0a\u7ebf\uff1a" + notifyProperties.getProjectName()).text(text);
    }

    private Object getContent(String tupleKey, Tuple2<String, Object> ... tuple2s) {
        return Arrays.stream(tuple2s).filter(t -> StringUtils.equals((CharSequence)((CharSequence)t._1()), (CharSequence)tupleKey)).findFirst().map(Tuple2::_2).orElse("");
    }

    private String readUtf8String(String path) {
        String resultReadStr;
        int endFlagCode = -1;
        ClassPathResource classPathResource = new ClassPathResource(path);
        try (InputStream inputStream = classPathResource.getInputStream();
             BufferedInputStream bis = new BufferedInputStream(inputStream);
             ByteArrayOutputStream buf = new ByteArrayOutputStream();){
            int result = bis.read();
            while (result != -1) {
                buf.write((byte)result);
                result = bis.read();
            }
            resultReadStr = buf.toString("UTF-8");
        }
        return resultReadStr;
    }
}

