/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.message.handler.ding;

import com.google.common.base.Joiner;
import com.xforceplus.general.alarm.configuration.NotifyProperties;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

public class ExceptionAlarmContent {
    protected String traceId;
    protected String project;
    protected NotifyProperties notifyProperties;
    protected String uid;
    protected String methodName;
    protected Map<String, String> parames;
    protected String classPath;
    protected String exceptionMessage;
    protected Throwable exception;
    protected List<String> traceInfo = new ArrayList<String>();
    private int times;

    public ExceptionAlarmContent(Throwable ex, String filterTrace) {
        this.exception = ex;
        this.exceptionMessage = this.gainExceptionMessage(ex);
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        for (StackTraceElement x2 : ex.getStackTrace()) {
            if (!(x2 != null & x2.getClassName() != null)) continue;
            if (StringUtils.isEmpty((Object)filterTrace)) {
                list.add(x2);
                continue;
            }
            if (!x2.getClassName().startsWith(filterTrace)) continue;
            list.add(x2);
        }
        if (list.size() > 0) {
            this.traceInfo = list.stream().map(x -> x.toString()).collect(Collectors.toList());
            this.methodName = ((StackTraceElement)list.get(0)).getMethodName();
            this.classPath = ((StackTraceElement)list.get(0)).getClassName();
        }
        this.uid = this.calUid();
    }

    public ExceptionAlarmContent(NotifyProperties notifyProperties, String traceId, Throwable ex, String filterTrace, Object[] args) {
        this(ex, filterTrace, args);
        this.traceId = traceId;
        this.notifyProperties = notifyProperties;
    }

    public ExceptionAlarmContent(Throwable ex, String filterTrace, Object[] args) {
        this(ex, filterTrace);
        int range = ArrayUtils.getLength((Object)args) / 2;
        this.parames = IntStream.range(0, range).boxed().collect(Collectors.toMap(i -> String.valueOf(args[2 * i]), i -> String.valueOf(args[2 * i + 1])));
    }

    private String gainExceptionMessage(Throwable exception) {
        String em = exception.toString();
        if (exception.getCause() != null) {
            em = String.format("%s\r\n\tcaused by : %s", em, this.gainExceptionMessage(exception.getCause()));
        }
        return em;
    }

    protected String calUid() {
        String traceInfoFirst = "";
        if (this.traceInfo != null && this.traceInfo.size() > 0) {
            traceInfoFirst = this.traceInfo.get(0);
        }
        String md5 = DigestUtils.md5DigestAsHex((byte[])String.format("%s-%s", this.exceptionMessage, traceInfoFirst).getBytes());
        return md5;
    }

    public String createText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[" + this.notifyProperties.getKeyword() + "]\r\n");
        stringBuilder.append("traceId:").append(this.traceId).append("\r\n");
        stringBuilder.append("appName\uff1a").append(this.notifyProperties.getProjectName()).append("\r\n");
        stringBuilder.append("env\uff1a").append(Joiner.on((String)"-").join((Object)System.getProperty("apollo.cluster"), (Object)System.getProperty("env"), new Object[0])).append("\r\n");
        stringBuilder.append("host\uff1a").append((String)Try.of((CheckedFunction0 & Serializable)() -> InetAddress.getLocalHost()).map(addr -> StringUtils.arrayToDelimitedString((Object[])new String[]{addr.getHostName(), addr.getHostAddress()}, (String)":")).getOrNull()).append("\r\n");
        stringBuilder.append("className\uff1a").append(this.classPath).append("\r\n");
        stringBuilder.append("methodName\uff1a").append(this.methodName).append("\r\n");
        stringBuilder.append("tag\uff1a").append(this.notifyProperties.getTag()).append("\r\n");
        if (this.parames != null && this.parames.size() > 0) {
            stringBuilder.append("parames\uff1a").append(Joiner.on((String)",").withKeyValueSeparator(":").join(this.parames)).append("\r\n");
        }
        stringBuilder.append("exceptionMessage\uff1a").append(this.exceptionMessage).append("\r\n");
        stringBuilder.append("stackTrace\uff1a").append("\r\n").append(String.join((CharSequence)"\r\n", this.traceInfo)).append("\r\n");
        stringBuilder.append("times\uff1a").append(this.getTimes()).append("\r\n");
        return stringBuilder.toString();
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public List<String> getTraceInfo() {
        return this.traceInfo;
    }

    public void setTraceInfo(List<String> traceInfo) {
        this.traceInfo = traceInfo;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public NotifyProperties getNotifyProperties() {
        return this.notifyProperties;
    }

    public Map<String, String> getParames() {
        return this.parames;
    }

    public int getTimes() {
        return this.times;
    }

    public void setNotifyProperties(NotifyProperties notifyProperties) {
        this.notifyProperties = notifyProperties;
    }

    public void setParames(Map<String, String> parames) {
        this.parames = parames;
    }

    public void setTimes(int times) {
        this.times = times;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionAlarmContent)) {
            return false;
        }
        ExceptionAlarmContent other = (ExceptionAlarmContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        NotifyProperties this$notifyProperties = this.getNotifyProperties();
        NotifyProperties other$notifyProperties = other.getNotifyProperties();
        if (this$notifyProperties == null ? other$notifyProperties != null : !((Object)this$notifyProperties).equals(other$notifyProperties)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        Map<String, String> this$parames = this.getParames();
        Map<String, String> other$parames = other.getParames();
        if (this$parames == null ? other$parames != null : !((Object)this$parames).equals(other$parames)) {
            return false;
        }
        String this$classPath = this.getClassPath();
        String other$classPath = other.getClassPath();
        if (this$classPath == null ? other$classPath != null : !this$classPath.equals(other$classPath)) {
            return false;
        }
        String this$exceptionMessage = this.getExceptionMessage();
        String other$exceptionMessage = other.getExceptionMessage();
        if (this$exceptionMessage == null ? other$exceptionMessage != null : !this$exceptionMessage.equals(other$exceptionMessage)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        List<String> this$traceInfo = this.getTraceInfo();
        List<String> other$traceInfo = other.getTraceInfo();
        if (this$traceInfo == null ? other$traceInfo != null : !((Object)this$traceInfo).equals(other$traceInfo)) {
            return false;
        }
        return this.getTimes() == other.getTimes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExceptionAlarmContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        NotifyProperties $notifyProperties = this.getNotifyProperties();
        result = result * 59 + ($notifyProperties == null ? 43 : ((Object)$notifyProperties).hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        Map<String, String> $parames = this.getParames();
        result = result * 59 + ($parames == null ? 43 : ((Object)$parames).hashCode());
        String $classPath = this.getClassPath();
        result = result * 59 + ($classPath == null ? 43 : $classPath.hashCode());
        String $exceptionMessage = this.getExceptionMessage();
        result = result * 59 + ($exceptionMessage == null ? 43 : $exceptionMessage.hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        List<String> $traceInfo = this.getTraceInfo();
        result = result * 59 + ($traceInfo == null ? 43 : ((Object)$traceInfo).hashCode());
        result = result * 59 + this.getTimes();
        return result;
    }

    public String toString() {
        return "ExceptionAlarmContent(traceId=" + this.getTraceId() + ", project=" + this.getProject() + ", notifyProperties=" + this.getNotifyProperties() + ", uid=" + this.getUid() + ", methodName=" + this.getMethodName() + ", parames=" + this.getParames() + ", classPath=" + this.getClassPath() + ", exceptionMessage=" + this.getExceptionMessage() + ", exception=" + this.getException() + ", traceInfo=" + this.getTraceInfo() + ", times=" + this.getTimes() + ")";
    }
}

