/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.alarm.message.handler.xforce;

import com.google.common.base.Splitter;
import com.xforceplus.general.alarm.adapter.driven.RemoteHttpAdapter;
import com.xforceplus.general.alarm.configuration.NotifyPlatformProperties;
import com.xforceplus.general.alarm.message.NotifyPlatform;
import com.xforceplus.general.alarm.message.handler.ContentType;
import com.xforceplus.general.alarm.message.handler.RobotSendMessageHandler;
import com.xforceplus.general.alarm.message.handler.ding.RobotMessageRequest;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="xforceSendMessageHandler")
public class XforceSendMessageHandler
implements RobotSendMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(XforceSendMessageHandler.class);
    private final RemoteHttpAdapter remoteHttpAdapter;

    @Override
    public NotifyPlatform notifyPlatform() {
        return NotifyPlatform.XFORCE;
    }

    @Override
    public void execute(RobotMessageRequest robotMessageRequest) {
        NotifyPlatformProperties notifyConfig = robotMessageRequest.getPlatformProperties();
        String serverUrl = notifyConfig.getSecretKey();
        String secret = notifyConfig.getSecret();
        if (StringUtils.isNotBlank((CharSequence)secret)) {
            long timestamp = System.currentTimeMillis();
            String stringToSign = timestamp + "\n" + secret;
            try {
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
                byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
                String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), StandardCharsets.UTF_8.name());
                serverUrl = serverUrl + "&timestamp=" + timestamp + "&sign=" + sign;
            }
            catch (Exception ex) {
                log.error("Failed to sign the message sent by nailing.", (Throwable)ex);
            }
        }
        String text = robotMessageRequest.getText();
        HashMap<String, Object> at = new HashMap<String, Object>();
        List atMobiles = Optional.ofNullable(notifyConfig.getReceives()).map(r -> Splitter.on((String)",").splitToList((CharSequence)r)).orElse(Collections.EMPTY_LIST);
        at.put("atMobiles", atMobiles);
        at.put("isAtAll", false);
        HashMap<String, Object> textJson = new HashMap<String, Object>();
        textJson.put("at", at);
        if (Optional.ofNullable(robotMessageRequest.getMsgtype()).orElse(ContentType.TEXT) == ContentType.TEXT) {
            textJson.put("msgtype", ContentType.TEXT.getContentType());
            HashMap<String, String> content = new HashMap<String, String>();
            content.put("content", text);
            textJson.put("text", content);
        } else {
            textJson.put("msgtype", ContentType.MARKDOWN.getContentType());
            HashMap<String, String> markdown = new HashMap<String, String>();
            markdown.put("title", robotMessageRequest.getTitle());
            markdown.put("text", text);
            textJson.put("markdown", markdown);
        }
        try {
            String response = this.remoteHttpAdapter.post(serverUrl, textJson, String.class);
            if (log.isDebugEnabled()) {
                log.debug("xforce  send message, response : {}", (Object)response);
            }
        }
        catch (Exception ex) {
            log.error("Ding failed to send message.", (Throwable)ex);
        }
    }

    public XforceSendMessageHandler(RemoteHttpAdapter remoteHttpAdapter) {
        this.remoteHttpAdapter = remoteHttpAdapter;
    }
}

