package com.xforceplus.general.apollo;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/10/28 13:54
 */
@Slf4j
public class ApolloAutoRefreshConfig implements ApplicationContextAware {

    ApplicationContext applicationContext;

    public ApolloAutoRefreshConfig() {
    }

    @ApolloConfigChangeListener
    public void onChange(final ConfigChangeEvent changeEvent) {
        log.info("begin refreshing  properties!");
        if (changeEvent.changedKeys() != null) {
            log.info("changedKeys: " + changeEvent.changedKeys().toString());
        }

        this.applicationContext.publishEvent(new EnvironmentChangeEvent(changeEvent.changedKeys()));
        log.info("end Refreshing  properties!");
    }

    @Override
    public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

}
