/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.cache.configuration;

import com.xforceplus.general.cache.configuration.properties.RedisProperties;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="xforce.gen-tool.redis", name={"enable"}, havingValue="false")
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedissonConfiguration {
    @Autowired
    private RedisProperties redisProperties;

    @Bean
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redissonClient() {
        Config config = new Config();
        if (StringUtils.isNotBlank((CharSequence)this.redisProperties.getHost())) {
            String address = String.format("redis://%s:%s", this.redisProperties.getHost(), this.redisProperties.getPort());
            SingleServerConfig serverConfig = (SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(address).setDatabase(this.redisProperties.getDatabase().intValue()).setConnectionPoolSize(this.redisProperties.getConnectionPoolSize().intValue()).setConnectionMinimumIdleSize(this.redisProperties.getConnectionMinimumIdleSize().intValue()).setConnectTimeout(this.redisProperties.getTimeout().intValue())).setTimeout(this.redisProperties.getTimeout().intValue());
            if (StringUtils.isNotBlank((CharSequence)this.redisProperties.getPassword())) {
                serverConfig.setPassword(this.redisProperties.getPassword());
            }
        } else {
            if (null == this.redisProperties.getSentinelNodes()) {
                throw new RuntimeException("You need to config the sentinelNodes property!");
            }
            SentinelServersConfig serversConfig = (SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(this.redisProperties.getSentinelMaster()).setMasterConnectionPoolSize(this.redisProperties.getConnectionPoolSize().intValue())).setMasterConnectionMinimumIdleSize(this.redisProperties.getConnectionMinimumIdleSize().intValue())).setSlaveConnectionPoolSize(this.redisProperties.getConnectionPoolSize().intValue())).setSlaveConnectionMinimumIdleSize(this.redisProperties.getConnectionMinimumIdleSize().intValue())).setConnectTimeout(this.redisProperties.getTimeout().intValue())).setTimeout(this.redisProperties.getTimeout().intValue());
            Arrays.stream(this.redisProperties.getSentinelNodes().split(",")).forEach(host -> serversConfig.addSentinelAddress(new String[]{"redis://" + host.trim()}));
            if (StringUtils.isNotBlank((CharSequence)this.redisProperties.getPassword())) {
                serversConfig.setPassword(this.redisProperties.getPassword());
            }
        }
        return Redisson.create((Config)config);
    }
}

