/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.general.cache.impl;

import com.xforceplus.general.cache.RedisService;
import com.xforceplus.general.cache.configuration.properties.RedissonProperties;
import com.xforceplus.general.utils.exception.BusinessException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    private static final long LOCK_WAIT_TIME_MILL_SECOND = 3000L;
    private static final long LEASE_TIME_MILL_SECOND = 60000L;
    @Autowired(required=false)
    private RedissonProperties redissonProperties;
    @Autowired(required=false)
    private RedissonClient redissonClient;

    private String renameKey(String key) {
        return String.format("%s:%s", this.redissonProperties.getAppId(), key);
    }

    @Override
    public <V> boolean set(String key, V val) {
        String cacheKey = this.renameKey(key);
        try {
            log.debug("Redis set key:{}, forever", (Object)cacheKey);
            RBucket bucket = this.redissonClient.getBucket(cacheKey);
            bucket.set(val);
            return true;
        }
        catch (Exception e) {
            log.error("Redis exp key:{} forever {}", (Object)cacheKey, (Object)e);
            return false;
        }
    }

    @Override
    public <V> boolean set(String key, V val, long expired, TimeUnit timeUnit) {
        String cacheKey = this.renameKey(key);
        try {
            log.info("Redis set key:{}, expired:{}, timeUnit:{}", new Object[]{cacheKey, expired, timeUnit});
            RBucket bucket = this.redissonClient.getBucket(cacheKey);
            bucket.set(val, expired, timeUnit);
            return true;
        }
        catch (Exception e) {
            log.error("Redis exp key:{} expired:{} {}", new Object[]{cacheKey, expired, e});
            return false;
        }
    }

    @Override
    public boolean delete(String key) {
        String cacheKey = this.renameKey(key);
        try {
            log.debug("Redis delete key:{}", (Object)cacheKey);
            this.redissonClient.getBucket(cacheKey).delete();
            return true;
        }
        catch (Exception e) {
            log.error("Redis exp delete key:{} {}", (Object)cacheKey, (Object)e);
            return false;
        }
    }

    @Override
    public <R> R get(String key) {
        String cacheKey = this.renameKey(key);
        try {
            log.debug("Redis get key:{}", (Object)cacheKey);
            RBucket bucket = this.redissonClient.getBucket(cacheKey);
            return (R)bucket.get();
        }
        catch (Exception e) {
            log.error("Redis exp get key:{} {}", (Object)cacheKey, (Object)e);
            return null;
        }
    }

    @Override
    public <R> R get(String key, Function<String, R> function, long timeToLive, TimeUnit timeUnit) {
        String cacheKey = this.renameKey(key);
        try {
            log.debug("Redis get key:{}", (Object)cacheKey);
            RBucket bucket = this.redissonClient.getBucket(cacheKey);
            Object r = bucket.get();
            if (r == null) {
                this.redissonClient.getBucket(cacheKey).set(function.apply(key), timeToLive, timeUnit);
            }
            return (R)r;
        }
        catch (Exception e) {
            log.error("Redis exp get key:{} {}", (Object)cacheKey, (Object)e);
            return null;
        }
    }

    @Override
    public void lock(String key, Runnable runnable) {
        block7: {
            RLock lock = this.redissonClient.getLock(this.renameKey(key));
            try {
                if (lock.tryLock(3000L, 60000L, TimeUnit.MILLISECONDS)) {
                    runnable.run();
                    break block7;
                }
                throw new BusinessException("\u5df2\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1:" + key + "\uff01", new Object[0]);
            }
            catch (InterruptedException e) {
                throw new BusinessException(e.getMessage(), new Object[0]);
            }
            finally {
                if (lock != null && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lock(String key, Supplier<T> supplier) {
        RLock lock = this.redissonClient.getLock(this.renameKey(key));
        if (lock.tryLock()) {
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        throw new BusinessException("\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01", new Object[0]);
    }
}

